/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.json.PropertyEligibility;
import net.mapeadores.util.text.StringUtils;

public class JsonParameters
implements PropertyEligibility {
    private static final String PROPERTIES_PREFIX = "properties=";
    private final Set<String> propertyNameSet;
    private final String cellConverterName;

    public JsonParameters(Set<String> propertyNameSet, String cellConverterName) {
        this.propertyNameSet = propertyNameSet;
        this.cellConverterName = cellConverterName;
    }

    @Override
    public boolean includeProperty(String propertyName) {
        if (propertyName.equals("properties")) {
            return this.cellConverterName != null;
        }
        return this.propertyNameSet.contains(propertyName);
    }

    @Nullable
    public String getCellConverterName() {
        return this.cellConverterName;
    }

    public static JsonParameters fromInstruction(Instruction instruction) {
        HashSet<String> propertyNameSet = new HashSet<String>();
        boolean here = false;
        String cellConverterName = null;
        for (Argument argument : instruction) {
            String key = argument.getKey();
            String value = argument.getValue();
            switch (key) {
                case "include": {
                    here = true;
                    if (value == null) break;
                    String[] tokens = StringUtils.getTechnicalTokens(value, true);
                    propertyNameSet.addAll(Arrays.asList(tokens));
                    break;
                }
                case "properties": 
                case "cells": {
                    if (value == null) break;
                    cellConverterName = value;
                    here = true;
                }
            }
        }
        if (!here) {
            return null;
        }
        return new JsonParameters(propertyNameSet, cellConverterName);
    }

    public static JsonParameters parse(String propertyNames) {
        HashSet<String> propertyNameSet = new HashSet<String>();
        String[] tokens = StringUtils.getTechnicalTokens(propertyNames, true);
        String cellConverterName = null;
        for (String token : tokens) {
            if (token.startsWith(PROPERTIES_PREFIX)) {
                cellConverterName = token.substring(PROPERTIES_PREFIX.length()).trim();
                if (cellConverterName.length() != 0) continue;
                cellConverterName = null;
                continue;
            }
            propertyNameSet.add(token);
        }
        propertyNameSet.addAll(Arrays.asList(tokens));
        return new JsonParameters(propertyNameSet, cellConverterName);
    }
}

