/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.album.Album;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FichothequeFormatDef;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.format.SubsetPathKey;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.formatters.AttributeFormatter;
import net.fichotheque.format.formatters.DocumentFormatter;
import net.fichotheque.format.formatters.ExtractionFormatter;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.format.formatters.FicheMetaFormatter;
import net.fichotheque.format.formatters.IllustrationFormatter;
import net.fichotheque.format.formatters.MotcleFormatter;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.format.formatters.ValueFormatter;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.format.formatters.AttributeFormatterParser;
import net.fichotheque.tools.format.formatters.DocumentFormatterParser;
import net.fichotheque.tools.format.formatters.ExtractionFormatterParser;
import net.fichotheque.tools.format.formatters.FicheBlockFormatterParser;
import net.fichotheque.tools.format.formatters.FicheItemFormatterParser;
import net.fichotheque.tools.format.formatters.FicheMetaFormatterParser;
import net.fichotheque.tools.format.formatters.FormatDefSourceFormatter;
import net.fichotheque.tools.format.formatters.IdalphaFormatterParser;
import net.fichotheque.tools.format.formatters.IllustrationFormatterParser;
import net.fichotheque.tools.format.formatters.MotcleFormatterParser;
import net.fichotheque.tools.format.formatters.SubfieldFormatterParser;
import net.fichotheque.tools.format.formatters.ValueFormatterParser;
import net.fichotheque.tools.format.tokenizers.AttributeTokenizer;
import net.fichotheque.tools.format.tokenizers.ChronoTokenizer;
import net.fichotheque.tools.format.tokenizers.DocumentTokenizer;
import net.fichotheque.tools.format.tokenizers.ExtractionTokenizer;
import net.fichotheque.tools.format.tokenizers.FicheBlockTokenizer;
import net.fichotheque.tools.format.tokenizers.FicheItemTokenizer;
import net.fichotheque.tools.format.tokenizers.FicheMetaTokenizer;
import net.fichotheque.tools.format.tokenizers.FicheParentageTokenizer;
import net.fichotheque.tools.format.tokenizers.IllustrationTokenizer;
import net.fichotheque.tools.format.tokenizers.LiageTokenizer;
import net.fichotheque.tools.format.tokenizers.MasterMotcleTokenizer;
import net.fichotheque.tools.format.tokenizers.MotcleTokenizer;
import net.fichotheque.tools.format.tokenizers.ParentageTokenizer;
import net.fichotheque.tools.format.tokenizers.SimpleValueTokenizer;
import net.fichotheque.tools.format.tokenizers.ThesaurusFieldTokenizer;
import net.fichotheque.tools.format.tokenizers.ThesaurusThisTokenizer;
import net.fichotheque.tools.format.tokenizers.TokenizerProvider;
import net.fichotheque.tools.format.tokenizers.subfield.SubfieldTokenizerFactory;
import net.fichotheque.utils.FichothequeFormatUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.format.FormatUtils;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.MessageHandler;

public class FichothequeFormatDefEngine {
    private final MessageHandler messageHandler;
    private final Subset mainSubset;
    private final Fichotheque fichotheque;
    private final FormatContext formatContext;
    private final InstructionResolverProvider provider;
    private final List<TokenizerProvider> sourceTokenizerProviderList = new ArrayList<TokenizerProvider>();
    private final String defaultSeparator;
    private final boolean defaultGlobalSelect;
    private final boolean ignoreMissingCorpusField;
    private SourceFormatter sourceFormatter;
    private short itemFilter;
    private boolean globalSelect;
    private boolean idSort;

    private FichothequeFormatDefEngine(Parameters parameters, Subset mainSubset, MessageHandler messageHandler) {
        this.mainSubset = mainSubset;
        this.fichotheque = mainSubset.getFichotheque();
        this.messageHandler = messageHandler;
        this.formatContext = parameters.formatContext;
        this.defaultSeparator = parameters.defaultSeparator;
        this.defaultGlobalSelect = parameters.defaultGlobalSelect;
        this.ignoreMissingCorpusField = parameters.ignoreMissingCorpusField;
        this.provider = this.formatContext.getInstructionResolverProvider();
    }

    public static SourceFormatter compute(Subset subset, FichothequeFormatDef formatDef, MessageHandler messageHandler, Parameters parameters) {
        if (!(subset instanceof Corpus) && !(subset instanceof Thesaurus)) {
            throw new IllegalArgumentException("wrong subset type");
        }
        FichothequeFormatDefEngine engine = new FichothequeFormatDefEngine(parameters, subset, messageHandler);
        boolean done = engine.init(formatDef);
        if (done) {
            return engine.sourceFormatter;
        }
        return null;
    }

    private boolean init(FichothequeFormatDef formatDef) {
        this.itemFilter = FormatUtils.getBoolean(formatDef, "noitem") ? (short)1 : (FormatUtils.getBoolean(formatDef, "onlyitem") ? (short)2 : (short)0);
        this.globalSelect = FormatUtils.getBoolean(formatDef, "globalselect", this.defaultGlobalSelect);
        this.idSort = FormatUtils.getBoolean(formatDef, "idsort");
        List<FormatSourceKey> formatSourceKeyList = formatDef.getFormatSourceKeyList();
        int size = formatSourceKeyList.size();
        for (int i = 0; i < size; ++i) {
            String pattern;
            FormatSourceKey formatSourceKey = formatSourceKeyList.get(i);
            if (this.init(formatSourceKey, pattern = FichothequeFormatUtils.getFormatPatternBySourceIndex(formatDef, i))) continue;
            return false;
        }
        this.sourceFormatter = FormatDefSourceFormatter.build(this.mainSubset, formatDef, TokenizerProvider.toByLangProvider(this.sourceTokenizerProviderList), this.defaultSeparator, this.formatContext);
        return true;
    }

    private boolean init(FormatSourceKey formatSourceKey, String pattern) {
        SubsetPathKey subsetPathKey = formatSourceKey.getSubsetPathKey();
        if (subsetPathKey == null) {
            TokenizerProvider sourceTokenizerProvider = this.mainSubset instanceof Thesaurus ? this.toSourceTokenizerProvider((Thesaurus)this.mainSubset, formatSourceKey, pattern) : this.toSourceTokenizerProvider((Corpus)this.mainSubset, formatSourceKey, pattern);
            if (sourceTokenizerProvider == null) {
                return false;
            }
            this.sourceTokenizerProviderList.add(sourceTokenizerProvider);
            return true;
        }
        Subset lastSubset = this.checkSubsetPathKey(subsetPathKey);
        if (lastSubset == null) {
            return false;
        }
        TokenizerProvider sourceTokenizerProvider = lastSubset instanceof Thesaurus ? this.toSourceTokenizerProvider((Thesaurus)lastSubset, formatSourceKey, pattern) : this.toSourceTokenizerProvider((Corpus)lastSubset, formatSourceKey, pattern);
        if (sourceTokenizerProvider == null) {
            return false;
        }
        this.sourceTokenizerProviderList.add(TokenizerProvider.subsetPath(this.fichotheque, subsetPathKey, sourceTokenizerProvider, this.globalSelect));
        return true;
    }

    private Subset checkSubsetPathKey(SubsetPathKey subsetPathKey) {
        int length = subsetPathKey.getLength();
        Subset currentSubset = this.mainSubset;
        block4: for (int i = 0; i < length; ++i) {
            short type = subsetPathKey.getKeyType(i);
            Object keyObject = subsetPathKey.getKeyObject(i);
            switch (type) {
                case 3: {
                    if (currentSubset instanceof Thesaurus) continue block4;
                    this.addSourceError("_ error.unsupported.subset_thesaurustree", currentSubset.getSubsetKey(), keyObject.toString());
                    return null;
                }
                case 1: {
                    SubsetKey parentageSubsetKey = (SubsetKey)keyObject;
                    Subset parentageSubset = this.fichotheque.getSubset(parentageSubsetKey);
                    if (parentageSubset == null) {
                        this.addSourceError("_ error.unknown.subset", parentageSubsetKey);
                        return null;
                    }
                    boolean test = FichothequeUtils.ownToSameParentage(parentageSubset, currentSubset);
                    if (!test) {
                        this.addSourceError("_ error.unsupported.parentage", parentageSubsetKey, currentSubset.getSubsetKey());
                        return null;
                    }
                    currentSubset = parentageSubset;
                    continue block4;
                }
                default: {
                    SubsetKey childSubsetKey = ((IncludeKey)keyObject).getSubsetKey();
                    Subset childSubset = this.fichotheque.getSubset(childSubsetKey);
                    if (childSubset == null) {
                        this.addSourceError("_ error.unknown.subset", childSubsetKey);
                        return null;
                    }
                    currentSubset = childSubset;
                }
            }
        }
        return currentSubset;
    }

    private TokenizerProvider toSourceTokenizerProvider(Corpus currentCorpus, FormatSourceKey formatSourceKey, String pattern) {
        short sourceType = formatSourceKey.getSourceType();
        Tokenizer tokenizer = null;
        switch (sourceType) {
            case 0: {
                tokenizer = this.initSpecialTokenizer(formatSourceKey, pattern);
                break;
            }
            case 1: {
                tokenizer = this.initFieldKey(currentCorpus, (FieldKey)formatSourceKey.getKeyObject(), pattern);
                break;
            }
            case 2: {
                tokenizer = this.initSubfieldKey(currentCorpus, formatSourceKey, pattern);
                break;
            }
            case 5: {
                return this.initNamePrefixFieldKey(currentCorpus, formatSourceKey, pattern);
            }
            case 3: {
                tokenizer = this.initIncludeKey(formatSourceKey, pattern);
                break;
            }
            case 4: {
                this.addSourceError("_ error.unsupported.formatsource", formatSourceKey.getKeyString());
                return null;
            }
            case 6: {
                tokenizer = this.initAttributeKey(formatSourceKey, pattern);
                break;
            }
            case 7: {
                tokenizer = this.initFieldKey(currentCorpus, FieldKey.ID, pattern);
                break;
            }
            case 10: {
                tokenizer = this.initFieldKey(currentCorpus, FieldKey.LANG, pattern);
                break;
            }
            case 8: {
                tokenizer = this.initParentageSubsetKey(currentCorpus, formatSourceKey, pattern);
                break;
            }
            case 9: {
                tokenizer = this.initSpecialInclude(currentCorpus, formatSourceKey, pattern);
                break;
            }
            default: {
                throw new SwitchException("Unknown sourceType: " + sourceType);
            }
        }
        if (tokenizer == null) {
            return null;
        }
        return TokenizerProvider.simple(tokenizer);
    }

    private TokenizerProvider toSourceTokenizerProvider(Thesaurus currentThesaurus, FormatSourceKey formatSourceKey, String pattern) {
        short sourceType = formatSourceKey.getSourceType();
        Tokenizer sourceTokenizer = null;
        switch (sourceType) {
            case 0: {
                sourceTokenizer = this.initSpecialTokenizer(formatSourceKey, pattern);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                this.addSourceError("_ error.unsupported.formatsource", formatSourceKey.getKeyString());
                return null;
            }
            case 3: {
                sourceTokenizer = this.initIncludeKey(formatSourceKey, pattern);
                break;
            }
            case 4: {
                sourceTokenizer = this.initThesaurusFieldKey(currentThesaurus, (ThesaurusFieldKey)formatSourceKey.getKeyObject(), pattern);
                break;
            }
            case 6: {
                sourceTokenizer = this.initAttributeKey(formatSourceKey, pattern);
                break;
            }
            case 7: {
                sourceTokenizer = this.initThesaurusFieldKey(currentThesaurus, ThesaurusFieldKey.ID, pattern);
                break;
            }
            case 10: {
                sourceTokenizer = this.initThesaurusFieldKey(currentThesaurus, ThesaurusFieldKey.BABELIENLANG, pattern);
                break;
            }
            case 8: {
                sourceTokenizer = this.initParentageSubsetKey(currentThesaurus, formatSourceKey, pattern);
                break;
            }
            case 9: {
                sourceTokenizer = this.initSpecialInclude(currentThesaurus, formatSourceKey, pattern);
                break;
            }
            default: {
                throw new SwitchException("Unknown sourceType: " + sourceType);
            }
        }
        if (sourceTokenizer == null) {
            return null;
        }
        return TokenizerProvider.simple(sourceTokenizer);
    }

    private Tokenizer initSpecialTokenizer(FormatSourceKey formatSourceKey, String pattern) {
        if (formatSourceKey.equals(FormatSourceKey.EXTRACTION)) {
            ExtractionFormatter extractionFormatter = ExtractionFormatterParser.parse(pattern, this.formatContext, this.messageHandler);
            if (extractionFormatter == null) {
                return null;
            }
            return new ExtractionTokenizer(extractionFormatter);
        }
        if (formatSourceKey.equals(FormatSourceKey.CONSTANT)) {
            return FormatterUtils.initConstantTokenizer(pattern);
        }
        return null;
    }

    private Tokenizer initThesaurusFieldKey(Thesaurus currentThesaurus, ThesaurusFieldKey thesaurusFieldKey, String pattern) {
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.THIS)) {
            MotcleFormatter motcleFormatter = MotcleFormatterParser.parse(currentThesaurus.isIdalphaType(), pattern, this.provider, false, this.messageHandler);
            if (motcleFormatter == null) {
                return null;
            }
            return new ThesaurusThisTokenizer(currentThesaurus, motcleFormatter);
        }
        ValueFormatter valueFormatter = thesaurusFieldKey.equals(ThesaurusFieldKey.IDALPHA) || thesaurusFieldKey.equals(ThesaurusFieldKey.PARENT_IDALPHA) ? IdalphaFormatterParser.parse(pattern, this.provider, this.messageHandler) : ValueFormatterParser.parse(pattern, this.provider, this.messageHandler);
        if (valueFormatter == null) {
            return null;
        }
        return new ThesaurusFieldTokenizer(currentThesaurus, thesaurusFieldKey, valueFormatter);
    }

    private Tokenizer initFieldKey(Corpus currentCorpus, FieldKey fieldKey, String pattern) {
        Tokenizer tokenizer;
        CorpusField corpusField = currentCorpus.getCorpusMetadata().getCorpusField(fieldKey);
        if (corpusField == null) {
            if (this.ignoreMissingCorpusField) {
                return FormatterUtils.EMPTY_TOKENIZER;
            }
            this.addSourceError("_ error.unknown.fieldkey", fieldKey);
            return null;
        }
        switch (FichothequeFormatDefEngine.getTokenizerType(corpusField)) {
            case 1: {
                tokenizer = this.createFicheBlockTokenizer(corpusField, pattern);
                break;
            }
            case 2: {
                ValueFormatter valueFormatter = ValueFormatterParser.parse(pattern, this.provider, this.messageHandler);
                if (valueFormatter == null) {
                    tokenizer = null;
                    break;
                }
                tokenizer = new SimpleValueTokenizer(corpusField, valueFormatter);
                break;
            }
            default: {
                tokenizer = this.createFicheItemTokenizer(corpusField, pattern);
            }
        }
        return tokenizer;
    }

    private TokenizerProvider initNamePrefixFieldKey(Corpus currentCorpus, FormatSourceKey formatSourceKey, String pattern) {
        FieldKey namePrefixFieldKey = (FieldKey)formatSourceKey.getKeyObject();
        HashMap<String, Tokenizer> tokenizerMap = new HashMap<String, Tokenizer>();
        String prefix = namePrefixFieldKey.getFieldName();
        int prefixLength = prefix.length();
        CorpusMetadata corpusMetadata = currentCorpus.getCorpusMetadata();
        switch (namePrefixFieldKey.getCategory()) {
            case 1: {
                for (CorpusField corpusField : corpusMetadata.getPropList()) {
                    String fieldName = corpusField.getFieldName();
                    if (!fieldName.startsWith(prefix)) continue;
                    String part2 = fieldName.substring(prefixLength);
                    Tokenizer sourceTokenizer = this.createFicheItemTokenizer(corpusField, pattern);
                    if (sourceTokenizer == null) {
                        return null;
                    }
                    tokenizerMap.put(part2, sourceTokenizer);
                }
                break;
            }
            case 2: {
                for (CorpusField corpusField : corpusMetadata.getInfoList()) {
                    String fieldName = corpusField.getFieldName();
                    if (!fieldName.startsWith(prefix)) continue;
                    String part2 = fieldName.substring(prefixLength);
                    Tokenizer sourceTokenizer = this.createFicheItemTokenizer(corpusField, pattern);
                    if (sourceTokenizer == null) {
                        return null;
                    }
                    tokenizerMap.put(part2, sourceTokenizer);
                }
                break;
            }
            case 3: {
                for (CorpusField corpusField : corpusMetadata.getSectionList()) {
                    String fieldName = corpusField.getFieldName();
                    if (!fieldName.startsWith(prefix)) continue;
                    String part2 = fieldName.substring(prefixLength);
                    Tokenizer tokenizer = this.createFicheBlockTokenizer(corpusField, pattern);
                    if (tokenizer == null) {
                        return null;
                    }
                    tokenizerMap.put(part2, tokenizer);
                }
                break;
            }
        }
        if (tokenizerMap.isEmpty()) {
            if (this.ignoreMissingCorpusField) {
                return TokenizerProvider.NULL;
            }
            this.addSourceError("_ error.unknown.fieldkeytypeprefix", namePrefixFieldKey);
            return null;
        }
        return TokenizerProvider.prefix(prefix, tokenizerMap);
    }

    private Tokenizer createFicheBlockTokenizer(CorpusField corpusField, String pattern) {
        FicheBlockFormatter ficheBlockFormatter = FicheBlockFormatterParser.parse(pattern, this.formatContext, this.messageHandler);
        if (ficheBlockFormatter == null) {
            return null;
        }
        return new FicheBlockTokenizer(corpusField, ficheBlockFormatter);
    }

    private Tokenizer createFicheItemTokenizer(CorpusField corpusField, String pattern) {
        FicheItemFormatter ficheItemFormatter = FicheItemFormatterParser.parse(corpusField, pattern, this.formatContext, this.messageHandler);
        if (ficheItemFormatter == null) {
            return null;
        }
        return FicheItemTokenizer.newInstance(corpusField, ficheItemFormatter, this.itemFilter);
    }

    private Tokenizer initSubfieldKey(Corpus currentCorpus, FormatSourceKey formatSourceKey, String pattern) {
        SubfieldKey subfieldKey = (SubfieldKey)formatSourceKey.getKeyObject();
        FieldKey fieldKey = subfieldKey.getFieldKey();
        CorpusField corpusField = currentCorpus.getCorpusMetadata().getCorpusField(fieldKey);
        if (corpusField == null) {
            if (this.ignoreMissingCorpusField) {
                return FormatterUtils.EMPTY_TOKENIZER;
            }
            this.addSourceError("_ error.unknown.subfieldkey", subfieldKey);
            return null;
        }
        if (!SubfieldKey.isLegalSubfield(corpusField, subfieldKey.getSubtype())) {
            this.addSourceError("_ error.unsupported.subfieldkey", subfieldKey);
            return null;
        }
        SubfieldFormatter subfieldFormatter = SubfieldFormatterParser.parse(subfieldKey.getSubtype(), pattern, this.formatContext, this.messageHandler);
        if (subfieldFormatter == null) {
            return null;
        }
        return SubfieldTokenizerFactory.newInstance(corpusField, subfieldKey, subfieldFormatter, this.fichotheque);
    }

    private Tokenizer initAttributeKey(FormatSourceKey formatSourceKey, String pattern) {
        AttributeKey attributeKey = (AttributeKey)formatSourceKey.getKeyObject();
        AttributeFormatter attributeFormatter = AttributeFormatterParser.parse(pattern, this.formatContext, this.messageHandler);
        if (attributeFormatter == null) {
            return null;
        }
        return new AttributeTokenizer(attributeKey, attributeFormatter);
    }

    private Tokenizer initSpecialInclude(Subset currentSubset, FormatSourceKey formatSourceKey, String pattern) {
        String specialIncludeName = (String)formatSourceKey.getKeyObject();
        if (specialIncludeName.equals("parentage")) {
            FicheMetaFormatter ficheMetaFormatter = FicheMetaFormatterParser.parse(pattern, this.formatContext, false, true, this.messageHandler);
            if (ficheMetaFormatter == null) {
                return null;
            }
            return new ParentageTokenizer(ficheMetaFormatter, this.globalSelect);
        }
        if (!(currentSubset instanceof Corpus)) {
            this.addSourceError("_ error.unsupported.formatsource", formatSourceKey.getKeyString());
            return null;
        }
        switch (specialIncludeName) {
            case "date_creation": 
            case "date_modification": {
                FicheItemFormatter ficheItemFormatter = FicheItemFormatterParser.parse("date", pattern, this.formatContext, this.messageHandler);
                if (ficheItemFormatter == null) {
                    return null;
                }
                return new ChronoTokenizer(specialIncludeName, ficheItemFormatter);
            }
            case "liage": {
                FicheMetaFormatter ficheMetaFormatter = FicheMetaFormatterParser.parse(pattern, this.formatContext, false, true, this.messageHandler);
                if (ficheMetaFormatter == null) {
                    return null;
                }
                return new LiageTokenizer(ficheMetaFormatter, this.globalSelect, this.formatContext.getLiageTest((Corpus)currentSubset));
            }
        }
        throw new SwitchException("Unknown special include name: " + specialIncludeName);
    }

    private Tokenizer initIncludeKey(FormatSourceKey formatSourceKey, String pattern) {
        IncludeKey includeKey = (IncludeKey)formatSourceKey.getKeyObject();
        SubsetKey subsetKey = includeKey.getSubsetKey();
        if (subsetKey.isCorpusSubset()) {
            Corpus corpus = (Corpus)this.fichotheque.getSubset(subsetKey);
            if (corpus == null) {
                this.addSourceError("_ error.unknown.subset", includeKey.getSubsetKey());
                return null;
            }
            FicheMetaFormatter ficheMetaFormatter = FicheMetaFormatterParser.parse(pattern, this.formatContext, includeKey.hasWeightFilter(), false, this.messageHandler);
            if (ficheMetaFormatter == null) {
                return null;
            }
            return new FicheMetaTokenizer(corpus, ficheMetaFormatter, includeKey.getMode(), includeKey.getWeightFilter(), this.globalSelect, this.idSort);
        }
        if (subsetKey.isThesaurusSubset()) {
            Thesaurus thesaurus = (Thesaurus)this.fichotheque.getSubset(subsetKey);
            if (thesaurus == null) {
                this.addSourceError("_ error.unknown.subset", includeKey.getSubsetKey());
                return null;
            }
            MotcleFormatter motcleFormatter = MotcleFormatterParser.parse(thesaurus.isIdalphaType(), pattern, this.provider, includeKey.hasWeightFilter(), this.messageHandler);
            if (motcleFormatter == null) {
                return null;
            }
            return new MotcleTokenizer(thesaurus, motcleFormatter, includeKey.getMode(), includeKey.getWeightFilter(), this.globalSelect);
        }
        if (subsetKey.isAlbumSubset()) {
            Album album = (Album)this.fichotheque.getSubset(subsetKey);
            if (album == null) {
                this.addSourceError("_ error.unknown.subset", includeKey.getSubsetKey());
                return null;
            }
            IllustrationFormatter illustrationFormatter = IllustrationFormatterParser.parse(pattern, this.formatContext, includeKey.hasWeightFilter(), this.messageHandler);
            if (illustrationFormatter == null) {
                return null;
            }
            return new IllustrationTokenizer(album, illustrationFormatter, includeKey.getMode(), includeKey.getWeightFilter(), this.globalSelect);
        }
        if (subsetKey.isAddendaSubset()) {
            Addenda addenda = (Addenda)this.fichotheque.getSubset(subsetKey);
            if (addenda == null) {
                this.addSourceError("_ error.unknown.subset", includeKey.getSubsetKey());
                return null;
            }
            DocumentFormatter documentFormatter = DocumentFormatterParser.parse(pattern, this.formatContext, includeKey.hasWeightFilter(), this.messageHandler);
            if (documentFormatter == null) {
                return null;
            }
            return new DocumentTokenizer(addenda, documentFormatter, includeKey.getMode(), includeKey.getWeightFilter(), this.globalSelect);
        }
        throw new SwitchException("Unknown include key: " + includeKey);
    }

    private Tokenizer initParentageSubsetKey(Subset currentSubset, FormatSourceKey formatSourceKey, String pattern) {
        SubsetKey parentageSubsetKey = (SubsetKey)formatSourceKey.getKeyObject();
        Subset parentageSubset = this.fichotheque.getSubset(parentageSubsetKey);
        if (parentageSubset == null) {
            this.addSourceError("_ error.unknown.subset", SubsetKey.toParentageString(parentageSubsetKey));
            return null;
        }
        boolean test = FichothequeUtils.ownToSameParentage(parentageSubset, currentSubset);
        if (!test) {
            this.addSourceError("_ error.unsupported.parentage", parentageSubsetKey, currentSubset.getSubsetKey());
            return null;
        }
        if (parentageSubset instanceof Thesaurus) {
            MotcleFormatter motcleFormatter = MotcleFormatterParser.parse(((Thesaurus)parentageSubset).isIdalphaType(), pattern, this.provider, false, this.messageHandler);
            if (motcleFormatter == null) {
                return null;
            }
            return new MasterMotcleTokenizer((Thesaurus)parentageSubset, motcleFormatter, this.globalSelect);
        }
        FicheMetaFormatter ficheMetaFormatter = FicheMetaFormatterParser.parse(pattern, this.formatContext, false, true, this.messageHandler);
        if (ficheMetaFormatter == null) {
            return null;
        }
        return new FicheParentageTokenizer((Corpus)parentageSubset, ficheMetaFormatter, this.globalSelect);
    }

    private void addSourceError(String messageKey, Object ... messageValues) {
        this.messageHandler.addMessage("severe.format.source", LocalisationUtils.toMessage(messageKey, messageValues));
    }

    public static Parameters parameters(FormatContext formatContext) {
        return new Parameters(formatContext);
    }

    private static int getTokenizerType(CorpusField corpusField) {
        switch (corpusField.getCategory()) {
            case 3: {
                return 1;
            }
            case 0: {
                switch (corpusField.getFieldString()) {
                    case "title": 
                    case "id": {
                        return 2;
                    }
                }
            }
        }
        return 0;
    }

    public static class Parameters {
        private final FormatContext formatContext;
        private String defaultSeparator = ";";
        private boolean defaultGlobalSelect = false;
        private boolean ignoreMissingCorpusField;

        private Parameters(FormatContext formatContext) {
            this.formatContext = formatContext;
        }

        public Parameters defaultSeparator(String defaultSeparator) {
            this.defaultSeparator = defaultSeparator;
            return this;
        }

        public Parameters defaultGlobalSelect(boolean defaultGlobalSelect) {
            this.defaultGlobalSelect = defaultGlobalSelect;
            return this;
        }

        public Parameters ignoreMissingCorpusField(boolean ignoreMissingCorpusField) {
            this.ignoreMissingCorpusField = ignoreMissingCorpusField;
            return this;
        }
    }
}

