/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.run.FicheGroup;
import net.fichotheque.tools.extraction.corpus.GroupBuilder;
import net.fichotheque.tools.extraction.corpus.GroupEngine;
import net.fichotheque.tools.extraction.corpus.GroupEngineProvider;
import net.fichotheque.utils.CroisementUtils;

class PositionEngine
extends GroupEngine {
    private final SortedMap<PositionSortKey, GroupBuilder> treeMap = new TreeMap<PositionSortKey, GroupBuilder>();
    private final GroupClause groupClause;
    private final GroupEngineProvider subGroupEngineProvider;

    PositionEngine(GroupClause groupClause, GroupEngineProvider subGroupEngineProvider) {
        this.groupClause = groupClause;
        this.subGroupEngineProvider = subGroupEngineProvider;
    }

    @Override
    public void add(FicheMeta ficheMeta, FicheFilter ficheFilter, Croisement croisement) {
        PositionSortKey positionSortKey;
        GroupBuilder groupBuilder;
        int position = -1;
        if (croisement != null) {
            position = CroisementUtils.getPosition(ficheMeta, croisement.getCroisementKey(), croisement.getLienList().get(0));
        }
        if ((groupBuilder = (GroupBuilder)this.treeMap.get(positionSortKey = new PositionSortKey(ficheMeta.getSubsetKey(), position))) == null) {
            TagNameInfo tagNameInfo = TagNameInfo.NULL;
            if (this.groupClause != null) {
                tagNameInfo = this.groupClause.getTagNameInfo();
            }
            groupBuilder = GroupBuilder.newInstance(positionSortKey.toString(), tagNameInfo, this.subGroupEngineProvider);
            this.treeMap.put(positionSortKey, groupBuilder);
        }
        groupBuilder.add(ficheMeta, ficheFilter, croisement);
    }

    @Override
    public FicheGroup[] toFicheGroupArray() {
        return PositionEngine.toGroupArray(this.treeMap.values(), this.groupClause, null);
    }

    private static class PositionSortKey
    implements Comparable<PositionSortKey> {
        private final SubsetKey subsetKey;
        private final int position;

        private PositionSortKey(SubsetKey subsetKey, int position) {
            this.subsetKey = subsetKey;
            this.position = position;
        }

        public int hashCode() {
            return this.subsetKey.hashCode() * 1000 + this.position;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            PositionSortKey otherPositionSortKey = (PositionSortKey)other;
            return otherPositionSortKey.subsetKey.equals(this.subsetKey) && otherPositionSortKey.position == this.position;
        }

        public String toString() {
            return this.subsetKey + "/" + this.position;
        }

        @Override
        public int compareTo(PositionSortKey otherPositionSortKey) {
            int compare = this.subsetKey.compareTo(otherPositionSortKey.subsetKey);
            if (compare != 0) {
                return compare;
            }
            if (otherPositionSortKey.position < 1 && this.position >= 1) {
                return -1;
            }
            if (otherPositionSortKey.position >= 1 && this.position < 1) {
                return 1;
            }
            if (otherPositionSortKey.position > this.position) {
                return -1;
            }
            if (otherPositionSortKey.position < this.position) {
                return 1;
            }
            return 0;
        }
    }
}

