/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import net.fichotheque.Subset;
import net.fichotheque.exportation.table.CroisementTable;

public class CroisementTableBuilder {
    private final Subset subset1;
    private final Subset subset2;
    private String tableName;

    public CroisementTableBuilder(Subset subset1, Subset subset2) {
        this.subset1 = subset1;
        this.subset2 = subset2;
    }

    public CroisementTableBuilder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public CroisementTable toCroisementTable() {
        String finalTableName = this.tableName;
        if (finalTableName == null || finalTableName.isEmpty()) {
            finalTableName = this.subset1.getSubsetKeyString() + "_" + this.subset2.getSubsetKeyString();
        }
        return new InternalCroisementTable(this.subset1, this.subset2, finalTableName);
    }

    public static CroisementTableBuilder init(Subset subset1, Subset subset2) {
        return new CroisementTableBuilder(subset1, subset2);
    }

    private static class InternalCroisementTable
    implements CroisementTable {
        private final Subset subset1;
        private final Subset subset2;
        private final String tableName;

        private InternalCroisementTable(Subset subset1, Subset subset2, String tableName) {
            this.subset1 = subset1;
            this.subset2 = subset2;
            this.tableName = tableName;
        }

        @Override
        public Subset getSubset1() {
            return this.subset1;
        }

        @Override
        public Subset getSubset2() {
            return this.subset2;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }
    }
}

