/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.scrutari;

import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.scrutari.CorpusScrutariDef;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.tools.exportation.scrutari.WrongFormatSourceKeyException;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.StringUtils;

public class CorpusScrutariDefBuilder {
    private final SubsetKey corpusKey;
    private final Set<String> includeTokenSet = new LinkedHashSet<String>();
    private FormatSourceKey dateFormatSourceKey;
    private AccoladePattern hrefPattern;
    private String multilangMode;
    private String multilangParam;
    private String fieldGenerationSource = "";

    public CorpusScrutariDefBuilder(SubsetKey corpusKey) {
        this.corpusKey = corpusKey;
    }

    public CorpusScrutariDefBuilder setDateKey(FormatSourceKey dateFormatSourceKey) {
        this.dateFormatSourceKey = dateFormatSourceKey;
        return this;
    }

    public CorpusScrutariDefBuilder setDateKey(String s) throws ParseException, WrongFormatSourceKeyException {
        this.dateFormatSourceKey = CorpusScrutariDefBuilder.parseDateKey(s);
        return this;
    }

    public CorpusScrutariDefBuilder setHrefPattern(AccoladePattern hrefPattern) {
        this.hrefPattern = hrefPattern;
        return this;
    }

    public CorpusScrutariDefBuilder setLanguiMode() {
        this.multilangMode = "langui";
        this.multilangParam = null;
        return this;
    }

    public CorpusScrutariDefBuilder setThesaurusMode(SubsetKey thesaurusKey) {
        if (!thesaurusKey.isThesaurusSubset()) {
            throw new IllegalArgumentException("!thesaurusKey.isThesaurusSubset()");
        }
        this.multilangMode = "thesaurus";
        this.multilangParam = thesaurusKey.getSubsetName();
        return this;
    }

    public CorpusScrutariDefBuilder setFieldGenerationSource(String source) {
        if (source == null) {
            source = "";
        }
        this.fieldGenerationSource = source;
        return this;
    }

    public CorpusScrutariDefBuilder setFieldMode(FieldKey fieldKey) {
        this.multilangMode = "field";
        this.multilangParam = fieldKey.getKeyString();
        return this;
    }

    public CorpusScrutariDefBuilder setCustomMode(Langs langs) {
        this.multilangMode = "custom";
        this.multilangParam = langs.toString(";");
        return this;
    }

    public CorpusScrutariDefBuilder setMultilang(String multilangMode, String multilangParam) {
        this.multilangMode = multilangMode;
        this.multilangParam = multilangParam;
        return this;
    }

    public CorpusScrutariDefBuilder addIncludeToken(String includeToken) {
        if (includeToken != null && includeToken.length() > 0) {
            this.includeTokenSet.add(includeToken);
        }
        return this;
    }

    public CorpusScrutariDefBuilder parseIncludeTokens(String includeTokens) {
        if (includeTokens != null) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens(includeTokens, true)) {
                this.includeTokenSet.add(token);
            }
        }
        return this;
    }

    public CorpusScrutariDef toCorpusScrutariDef() {
        List<String> includeTokenList = StringUtils.toList(this.includeTokenSet);
        return new InternalCorpusScrutariDef(this.corpusKey, this.dateFormatSourceKey, this.fieldGenerationSource, this.hrefPattern, this.multilangMode, this.multilangParam, includeTokenList);
    }

    public static CorpusScrutariDefBuilder init(SubsetKey corpusKey) {
        return new CorpusScrutariDefBuilder(corpusKey);
    }

    public static FormatSourceKey parseDateKey(String s) throws ParseException, WrongFormatSourceKeyException {
        if (s.equals("date_creation")) {
            return FormatSourceKey.DATE_CREATION;
        }
        if (s.equals("date_modification")) {
            return FormatSourceKey.DATE_MODIFICATION;
        }
        FieldKey fieldKey = FieldKey.parse(s);
        switch (fieldKey.getCategory()) {
            case 1: 
            case 2: {
                return FormatSourceKey.newFieldKeyInstance(fieldKey);
            }
        }
        throw new WrongFormatSourceKeyException();
    }

    private static class InternalCorpusScrutariDef
    implements CorpusScrutariDef {
        private final SubsetKey corpusKey;
        private final FormatSourceKey dateFormatSourceKey;
        private final String fieldGenerationSource;
        private final AccoladePattern hrefPattern;
        private final String multilangMode;
        private final String multilangParam;
        private final List<String> includeTokenList;

        private InternalCorpusScrutariDef(SubsetKey corpusKey, FormatSourceKey dateFormatSourceKey, String fieldGenerationSource, AccoladePattern hrefPattern, String multilangMode, String multilangParam, List<String> includeTokenList) {
            this.corpusKey = corpusKey;
            this.dateFormatSourceKey = dateFormatSourceKey;
            this.fieldGenerationSource = fieldGenerationSource;
            this.hrefPattern = hrefPattern;
            this.multilangMode = multilangMode;
            this.multilangParam = multilangParam;
            this.includeTokenList = includeTokenList;
        }

        @Override
        public String getFieldGenerationSource() {
            return this.fieldGenerationSource;
        }

        @Override
        public SubsetKey getCorpusKey() {
            return this.corpusKey;
        }

        @Override
        public FormatSourceKey getDateFormatSourceKey() {
            return this.dateFormatSourceKey;
        }

        @Override
        public AccoladePattern getHrefPattern() {
            return this.hrefPattern;
        }

        @Override
        public String getMultilangMode() {
            return this.multilangMode;
        }

        @Override
        public String getMultilangParam() {
            return this.multilangParam;
        }

        @Override
        public List<String> getIncludeTokenList() {
            return this.includeTokenList;
        }
    }
}

