/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.corpus;

import net.fichotheque.FichothequeEditor;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.ExistingFieldKeyException;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.corpus.FieldGenerationEngine;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.Label;

public final class CorpusTools {
    private CorpusTools() {
    }

    public static void copy(CorpusEditor corpusEditor, FicheMeta origin, FicheMeta destination, FicheAPI fiche) {
        corpusEditor.setDate(destination, origin.getCreationDate(), false);
        corpusEditor.setDate(destination, origin.getModificationDate(), true);
        FichothequeEditor fichothequeEditor = corpusEditor.getFichothequeEditor();
        for (Attribute attribute : origin.getAttributes()) {
            fichothequeEditor.putAttribute(destination, attribute);
        }
        corpusEditor.saveFiche(destination, fiche);
    }

    public static void copy(CorpusMetadata origin, CorpusMetadataEditor destination) {
        CorpusCloneEngine engine = new CorpusCloneEngine(origin, destination);
        engine.run();
    }

    public static void saveFiche(CorpusEditor corpusEditor, FicheMeta ficheMeta, Fiche fiche, FieldGenerationEngine engine, boolean modificationDate) {
        if (modificationDate) {
            corpusEditor.setDate(ficheMeta, FuzzyDate.current(), true);
        }
        engine.run(ficheMeta, fiche);
        corpusEditor.saveFiche(ficheMeta, fiche);
    }

    private static class CorpusCloneEngine {
        private final CorpusMetadata corpusMetadata;
        private final CorpusMetadataEditor newCorpusMetadataEditor;

        private CorpusCloneEngine(CorpusMetadata corpusMetadata, CorpusMetadataEditor newCorpusMetadataEditor) {
            this.corpusMetadata = corpusMetadata;
            this.newCorpusMetadataEditor = newCorpusMetadataEditor;
        }

        private void run() {
            FichothequeTools.copy(this.corpusMetadata, this.newCorpusMetadataEditor, " (2)");
            this.copyMandatoryField(FieldKey.TITLE);
            this.copyMandatoryField(FieldKey.LANG);
            this.copyMandatoryField(FieldKey.OWNERS);
            this.copySpecialField(FieldKey.SUBTITLE);
            for (CorpusField corpusField : this.corpusMetadata.getPropList()) {
                this.copyField(corpusField);
            }
            for (CorpusField corpusField : this.corpusMetadata.getInfoList()) {
                this.copyField(corpusField);
            }
            for (CorpusField corpusField : this.corpusMetadata.getSectionList()) {
                this.copyField(corpusField);
            }
            this.newCorpusMetadataEditor.setFieldGeneration(this.corpusMetadata.getFieldGeneration());
            CorpusField geolocalisationField = this.corpusMetadata.getGeolocalisationField();
            if (geolocalisationField != null) {
                this.newCorpusMetadataEditor.setGeolocalisationField(((CorpusMetadata)this.newCorpusMetadataEditor.getMetadata()).getCorpusField(geolocalisationField.getFieldKey()));
            }
        }

        private void copyMandatoryField(FieldKey fieldKey) {
            CorpusField corpusField = this.corpusMetadata.getCorpusField(fieldKey);
            CorpusField newCorpusField = ((CorpusMetadata)this.newCorpusMetadataEditor.getMetadata()).getCorpusField(fieldKey);
            this.copyField(corpusField, newCorpusField);
        }

        private void copySpecialField(FieldKey fieldKey) {
            CorpusField corpusField = this.corpusMetadata.getCorpusField(fieldKey);
            if (corpusField == null) {
                return;
            }
            try {
                CorpusField newCorpusField = this.newCorpusMetadataEditor.createCorpusField(fieldKey, "");
                this.copyField(corpusField, newCorpusField);
            }
            catch (ExistingFieldKeyException efke) {
                throw new ShouldNotOccurException("new corpus");
            }
        }

        private void copyField(CorpusField corpusField) {
            try {
                CorpusField newCorpusField = this.newCorpusMetadataEditor.createCorpusField(corpusField.getFieldKey(), corpusField.getFicheItemType());
                this.copyField(corpusField, newCorpusField);
            }
            catch (ExistingFieldKeyException efke) {
                throw new ShouldNotOccurException("new corpus");
            }
        }

        private void copyField(CorpusField corpusField, CorpusField newCorpusField) {
            for (Label label : corpusField.getLabels()) {
                this.newCorpusMetadataEditor.putFieldLabel(newCorpusField, label);
            }
            try {
                for (String optionName : corpusField.getOptionNameSet()) {
                    this.newCorpusMetadataEditor.setFieldOption(newCorpusField, optionName, corpusField.getOption(optionName));
                }
            }
            catch (FieldOptionException foe) {
                throw new ShouldNotOccurException("clone corpus");
            }
        }
    }
}

