/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.uml;

import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.uml.UmlClass;

public class BdfPumlUtils {
    private BdfPumlUtils() {
    }

    public static UmlClass buildCorpusUmlClass(Corpus corpus, Lang lang, MessageLocalisation messageLocalisation) {
        UmlClass umlClass = BdfPumlUtils.buildUmlClass(corpus, lang);
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        CorpusField subtitle = corpusMetadata.getCorpusField(FieldKey.SUBTITLE);
        if (subtitle != null) {
            umlClass.addField(CorpusMetadataUtils.getFieldTitle(subtitle, lang));
        }
        BdfPumlUtils.addFieldList(umlClass, corpusMetadata.getPropList(), lang, messageLocalisation, "_ title.corpus.fields_prop");
        BdfPumlUtils.addFieldList(umlClass, corpusMetadata.getInfoList(), lang, messageLocalisation, "_ title.corpus.fields_info");
        BdfPumlUtils.addFieldList(umlClass, corpusMetadata.getSectionList(), lang, messageLocalisation, "_ title.corpus.fields_section");
        return umlClass;
    }

    public static UmlClass buildUmlClass(Subset subset, Lang lang) {
        String color;
        char letter;
        SubsetKey subsetKey = subset.getSubsetKey();
        short subsetCategory = subsetKey.getCategory();
        if (subsetKey.isCorpusSubset()) {
            Subset masterSubset = ((Corpus)subset).getMasterSubset();
            if (masterSubset != null) {
                letter = 'S';
                color = "#e2e2e2";
            } else {
                letter = BdfPumlUtils.getLetter((short)1);
                color = BdfPumlUtils.getColor((short)1);
            }
        } else {
            letter = BdfPumlUtils.getLetter(subsetCategory);
            color = BdfPumlUtils.getColor(subsetCategory);
        }
        return UmlClass.init(subsetKey.getKeyString()).title(FichothequeUtils.getTitle(subset, lang)).circle(letter, color);
    }

    private static char getLetter(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return 'C';
            }
            case 2: {
                return 'T';
            }
            case 3: {
                return 'U';
            }
            case 4: {
                return 'D';
            }
            case 5: {
                return 'I';
            }
        }
        throw new IllegalArgumentException("wrong croisementCategory value");
    }

    private static String getColor(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return "#ffbdbd";
            }
            case 2: {
                return "#acf2fe";
            }
            case 3: {
                return "#b8ffb8";
            }
            case 4: {
                return "#ffdfb8";
            }
            case 5: {
                return "#f5c4fd";
            }
        }
        throw new IllegalArgumentException("wrong croisementCategory value");
    }

    public static String getRelation(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return " -- ";
            }
            case 2: {
                return " <-- ";
            }
            case 3: {
                return " -- ";
            }
            case 4: {
                return " o-left- ";
            }
            case 5: {
                return " o-right- ";
            }
        }
        throw new IllegalArgumentException("wrong croisementCategory value");
    }

    private static void addFieldList(UmlClass umlClass, List<CorpusField> fieldList, Lang lang, MessageLocalisation messageLocalisation, String locKey) {
        if (fieldList.isEmpty()) {
            return;
        }
        umlClass.addSeparator(messageLocalisation.toString(locKey));
        for (CorpusField corpusField : fieldList) {
            umlClass.addField(CorpusMetadataUtils.getFieldTitle(corpusField, lang));
        }
    }
}

