/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ui.dom;

import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.tools.ui.UiComponentsBuilder;
import fr.exemole.bdfserver.tools.ui.components.UiDOMUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class UiComponentsDOMReader {
    private final UiComponentsBuilder uiComponentsBuilder;
    private final HtmlCleaner htmlCleaner;
    private final MessageHandler messageHandler;
    private final Map<String, CommentUi> commentUiMap = new HashMap<String, CommentUi>();

    public UiComponentsDOMReader(UiComponentsBuilder uiComponentsBuilder, HtmlCleaner htmlCleaner, MessageHandler messageHandler) {
        this.uiComponentsBuilder = uiComponentsBuilder;
        this.messageHandler = messageHandler;
        this.htmlCleaner = htmlCleaner;
    }

    public void readUiComponents(Element element) {
        DOMUtils.readChildren(element, new FirstStepConsumer());
        DOMUtils.readChildren(element, new SecondStepConsumer());
    }

    private class FirstStepConsumer
    implements Consumer<Element> {
        private FirstStepConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("metadata")) {
                DOMUtils.readChildren(element, new MetadataConsumer());
            }
        }
    }

    private class SecondStepConsumer
    implements Consumer<Element> {
        private SecondStepConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "metadata": {
                    break;
                }
                case "comment": {
                    CommentUi commentUi = UiDOMUtils.readCommentUi(element, UiComponentsDOMReader.this.htmlCleaner, UiComponentsDOMReader.this.messageHandler, "comment");
                    if (commentUi == null) break;
                    CommentUi existingCommentUi = (CommentUi)UiComponentsDOMReader.this.commentUiMap.get(commentUi.getCommentName());
                    if (existingCommentUi != null) {
                        UiComponentsDOMReader.this.uiComponentsBuilder.addUiComponent(existingCommentUi);
                        break;
                    }
                    UiComponentsDOMReader.this.uiComponentsBuilder.addUiComponent(commentUi);
                    break;
                }
                case "field-ui": {
                    FieldUi fieldUi = UiDOMUtils.readFieldUi(element, UiComponentsDOMReader.this.messageHandler, "field-ui");
                    if (fieldUi == null) break;
                    UiComponentsDOMReader.this.uiComponentsBuilder.addUiComponent(fieldUi);
                    break;
                }
                case "subset-ui": {
                    IncludeUi includeUi = UiDOMUtils.readSubsetIncludeUi(element, UiComponentsDOMReader.this.messageHandler, "subset-ui");
                    if (includeUi == null) break;
                    UiComponentsDOMReader.this.uiComponentsBuilder.addUiComponent(includeUi);
                    break;
                }
                case "special-ui": {
                    IncludeUi includeUi = UiDOMUtils.readSpecialIncludeUi(element, UiComponentsDOMReader.this.messageHandler, "special-ui");
                    if (includeUi == null) break;
                    UiComponentsDOMReader.this.uiComponentsBuilder.addUiComponent(includeUi);
                    break;
                }
                case "data-ui": {
                    DataUi dataUi = UiDOMUtils.readDataUi(element, UiComponentsDOMReader.this.messageHandler, "data-ui");
                    if (dataUi == null) break;
                    UiComponentsDOMReader.this.uiComponentsBuilder.addUiComponent(dataUi);
                    break;
                }
                default: {
                    DomMessages.unknownTagWarning(UiComponentsDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }

    private class MetadataConsumer
    implements Consumer<Element> {
        private MetadataConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("comment-def")) {
                CommentUi commentUi = UiDOMUtils.readCommentUi(element, UiComponentsDOMReader.this.htmlCleaner, UiComponentsDOMReader.this.messageHandler, "comment-def");
                if (commentUi != null) {
                    UiComponentsDOMReader.this.commentUiMap.put(commentUi.getCommentName(), commentUi);
                }
            } else {
                DomMessages.unknownTagWarning(UiComponentsDOMReader.this.messageHandler, tagName);
            }
        }
    }
}

