/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.synthesis;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.synthesis.RedacteurSynthesis;
import fr.exemole.bdfserver.tools.synthesis.SphereSynthesis;
import fr.exemole.bdfserver.tools.synthesis.Synthesis;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdUtils;
import net.mapeadores.opendocument.io.OdZip;
import net.mapeadores.opendocument.io.OdZipEngine;
import net.mapeadores.opendocument.io.SheetNameChecker;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.opendocument.io.odtable.OdsOptions;
import net.mapeadores.opendocument.io.odtable.OdsXMLPart;
import net.mapeadores.opendocument.io.odtable.StyleManager;
import net.mapeadores.opendocument.io.odtable.StyleManagerBuilder;
import net.mapeadores.opendocument.io.odtable.TableSettings;
import net.mapeadores.util.io.TempStorageAppendable;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class SynthesisOds {
    private final Synthesis synthesis;
    private final SheetNameChecker sheetNameChecker;
    private final MessageLocalisation messageLocalisation;
    private final Lang lang;
    private final SphereSynthesis[] sphereSynthesisArray;
    private final BdfServer[] bdfServerArray;
    private final OdsOptions odsOptions;
    private final String summaryTableName;
    private final Map<String, String> sphereTableNameMap = new HashMap<String, String>();

    public SynthesisOds(Synthesis synthesis, OdsOptions odsOptions, Lang lang, MessageLocalisation messageLocalisation) {
        this.synthesis = synthesis;
        this.lang = lang;
        this.messageLocalisation = messageLocalisation;
        this.sphereSynthesisArray = synthesis.getSphereSynthesisArray();
        this.bdfServerArray = synthesis.getBdfServerArray();
        this.odsOptions = odsOptions;
        this.sheetNameChecker = new SheetNameChecker();
        this.summaryTableName = this.sheetNameChecker.checkName(messageLocalisation.toNotNullString("_ title.global.summary"));
        this.initSphereNameMap();
    }

    public void write(OutputStream outputStream) throws IOException {
        OdZipEngine.run(outputStream, OdZip.spreadSheet().stylesOdSource(OdUtils.toStyleOdSource(this.odsOptions.elementMaps(), true)).contentOdSource(new ContentOdSource()).settingsOdSource(OdUtils.getSettingsOdSource(this.getSettings())));
    }

    private List<TableSettings> getSettings() {
        ArrayList<TableSettings> settingsList = new ArrayList<TableSettings>();
        settingsList.add(TableSettings.init(this.summaryTableName).fixedColumns(2).fixedRows(2));
        for (SphereSynthesis sphereSynthesis : this.sphereSynthesisArray) {
            settingsList.add(TableSettings.init(this.getTableName(sphereSynthesis)).fixedRows(2).fixedColumns(2));
        }
        return settingsList;
    }

    private void initSphereNameMap() {
        for (SphereSynthesis sphereSynthesis : this.sphereSynthesisArray) {
            String sphereName = sphereSynthesis.getSphereName();
            String sphereTitle = sphereSynthesis.getLabels().seekLabelString(this.lang, "");
            String tableName = !sphereTitle.isEmpty() ? sphereName + " (" + sphereTitle + ")" : sphereName;
            tableName = this.sheetNameChecker.checkName(tableName);
            this.sphereTableNameMap.put(sphereName, tableName);
        }
    }

    private String getTableName(SphereSynthesis sphereSynthesis) {
        return this.sphereTableNameMap.get(sphereSynthesis.getSphereName());
    }

    private String getFichothequeTitle(String fichothequeName) {
        BdfServer bdfServer = this.synthesis.getBdfServer(fichothequeName);
        if (bdfServer != null) {
            return this.getFichothequeTitle(bdfServer.getFichotheque());
        }
        return "";
    }

    private String getFichothequeTitle(Fichotheque fichotheque) {
        return fichotheque.getFichothequeMetadata().getTitleLabels().seekLabelString(this.lang, "");
    }

    private String getSpecificInfoText(SphereSynthesis.SpecificInfo specificInfo) {
        List<Label> labelList = specificInfo.getLabelList();
        StringBuilder buf = new StringBuilder();
        buf.append(this.messageLocalisation.toNotNullString("_ label.multi.specificphrases"));
        buf.append(this.messageLocalisation.toNotNullString("_ label.global.colon"));
        buf.append(" ");
        boolean next = false;
        for (Label label : labelList) {
            if (next) {
                buf.append(" / ");
            } else {
                next = true;
            }
            buf.append(label.getLabelString());
            buf.append(" (");
            buf.append(label.getLang().toString());
            buf.append(")");
        }
        return buf.toString();
    }

    private String getNameAnnotation(RedacteurSynthesis redacteurSynthesis) {
        List<String> otherNameList = redacteurSynthesis.getOtherNameList();
        if (otherNameList.isEmpty()) {
            return null;
        }
        String l10nKey = otherNameList.size() == 1 ? "_ label.multi.specificname_one" : "_ label.multi.specificname_many";
        StringBuilder buf = new StringBuilder();
        buf.append(this.messageLocalisation.toNotNullString(l10nKey));
        buf.append(this.messageLocalisation.toNotNullString("_ label.global.colon"));
        buf.append(" ");
        boolean next = false;
        for (String otherName : otherNameList) {
            if (next) {
                buf.append(" / ");
            } else {
                next = true;
            }
            buf.append(otherName);
        }
        return buf.toString();
    }

    private String getSpecificFichothequeStatusText(RedacteurSynthesis.FichothequeStatus fichothequeStatus) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.messageLocalisation.toNotNullString("_ label.multi.specificname_one"));
        buf.append(this.messageLocalisation.toNotNullString("_ label.global.colon"));
        buf.append(" ");
        buf.append(fichothequeStatus.getSpecificName());
        return buf.toString();
    }

    private class ContentOdSource
    implements OdSource {
        private ContentOdSource() {
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            StyleManager styleManager = this.initStyleManager();
            TempStorageAppendable bodyBuffer = new TempStorageAppendable();
            ContentXMLPart xmlPart = new ContentXMLPart(XMLUtils.toXMLWriter(bodyBuffer, 3), styleManager);
            xmlPart.writeSummaryTable();
            for (SphereSynthesis sphereSynthesis : SynthesisOds.this.sphereSynthesisArray) {
                xmlPart.writeSphereSynthesisTable(sphereSynthesis);
            }
            xmlPart.insertErrorLogTable(SynthesisOds.this.odsOptions.odLog(), "css log");
            OdUtils.writeSpreadSheetDocumentContent(outputStream, bodyBuffer, styleManager);
        }

        private StyleManager initStyleManager() {
            StyleManagerBuilder styleManagerBuilder = StyleManagerBuilder.init().setElementMaps(SynthesisOds.this.odsOptions.elementMaps());
            styleManagerBuilder.addTableDef(OdTableDefBuilder.init(SynthesisOds.this.summaryTableName).addStandard("FixedColumn").addStandard("FixedColumn").addStandards(SynthesisOds.this.sphereSynthesisArray.length).toOdTableDef());
            for (SphereSynthesis sphereSynthesis : SynthesisOds.this.sphereSynthesisArray) {
                styleManagerBuilder.addTableDef(OdTableDefBuilder.init(SynthesisOds.this.getTableName(sphereSynthesis)).addStandard("FixedColumn").addStandard("FixedColumn").addStandards(sphereSynthesis.getFichothequeSize()).toOdTableDef());
            }
            return styleManagerBuilder.toStyleManager();
        }
    }

    private class ContentXMLPart
    extends OdsXMLPart {
        private ContentXMLPart(XMLWriter xmlWriter, StyleManager styleManager) {
            super(xmlWriter, styleManager);
        }

        private void writeSummaryTable() throws IOException {
            this.tableStart(SynthesisOds.this.summaryTableName);
            this.rowStart();
            this.stringCell("", "Diagonal");
            this.stringCell(SynthesisOds.this.messageLocalisation.toNotNullString("_ title.global.sphere_collection"), "ColumnsLabel");
            for (SphereSynthesis sphereSynthesis : SynthesisOds.this.sphereSynthesisArray) {
                this.stringCell(sphereSynthesis.getSphereName(), "TopElementName");
            }
            this.rowEnd();
            this.rowStart();
            this.stringCell(SynthesisOds.this.messageLocalisation.toNotNullString("_ title.multi.fichotheques"), "RowsLabel");
            this.stringCell("", "Diagonal");
            for (SphereSynthesis sphereSynthesis : SynthesisOds.this.sphereSynthesisArray) {
                this.stringCell(sphereSynthesis.getLabels().seekLabelString(SynthesisOds.this.lang, ""), "TopElementTitle");
            }
            this.rowEnd();
            for (BdfServer bdfServer : SynthesisOds.this.bdfServerArray) {
                String fichothequeName = bdfServer.getName();
                this.rowStart();
                this.stringCell(fichothequeName, "ElementName");
                this.stringCell(SynthesisOds.this.getFichothequeTitle(bdfServer.getFichotheque()), "ElementTitle");
                for (SphereSynthesis sphereSynthesis : SynthesisOds.this.sphereSynthesisArray) {
                    Sphere sphere = sphereSynthesis.getSphere(fichothequeName);
                    if (sphere != null) {
                        SphereSynthesis.SpecificInfo specificInfo = sphereSynthesis.getSpecificInfo(fichothequeName);
                        String annotation = null;
                        if (specificInfo != null) {
                            annotation = SynthesisOds.this.getSpecificInfoText(specificInfo);
                        }
                        this.numberCell(String.valueOf(sphere.size()), "SphereName", 1, annotation);
                        continue;
                    }
                    this.stringCell("", "SphereName");
                }
                this.rowEnd();
            }
            this.tableEnd();
        }

        private void writeSphereSynthesisTable(SphereSynthesis sphereSynthesis) throws IOException {
            String[] fichothequeNameArray = sphereSynthesis.getFichothequeNameArray();
            this.tableStart(SynthesisOds.this.getTableName(sphereSynthesis));
            this.rowStart();
            this.stringCell("", "Diagonal");
            this.stringCell(SynthesisOds.this.messageLocalisation.toNotNullString("_ title.multi.fichotheques"), "ColumnsLabel");
            for (String fichothequeName : fichothequeNameArray) {
                this.stringCell(fichothequeName, "TopElementName");
            }
            this.rowEnd();
            this.rowStart();
            this.stringCell(SynthesisOds.this.messageLocalisation.toNotNullString("_ label.selection.users"), "RowsLabel");
            this.stringCell("", "Diagonal");
            for (String fichothequeName : fichothequeNameArray) {
                this.stringCell(SynthesisOds.this.getFichothequeTitle(fichothequeName), "TopElementTitle");
            }
            this.rowEnd();
            for (RedacteurSynthesis redacteurSynthesis : sphereSynthesis.getRedacteurSynthesisArray()) {
                this.rowStart();
                this.stringCell(redacteurSynthesis.getLogin(), "ElementName");
                this.stringCell(redacteurSynthesis.getCompleteName(), "ElementTitle", 1, SynthesisOds.this.getNameAnnotation(redacteurSynthesis));
                for (String fichothequeName : fichothequeNameArray) {
                    RedacteurSynthesis.FichothequeStatus status = redacteurSynthesis.getFichothequeStatus(fichothequeName);
                    if (status == null) {
                        this.stringCell("", "Status");
                        continue;
                    }
                    String annotation = null;
                    if (status.hasSpecificName()) {
                        annotation = SynthesisOds.this.getSpecificFichothequeStatusText(status);
                    }
                    this.addLevelCell(status.getLevel(), annotation);
                }
                this.rowEnd();
            }
            this.tableEnd();
        }

        private void addLevelCell(String level, String annotation) throws IOException {
            String style = null;
            switch (level) {
                case "A": {
                    style = "Admin";
                    break;
                }
                case "C": {
                    style = "Readonly";
                    break;
                }
                case "D": {
                    style = "Inactive";
                    break;
                }
                default: {
                    style = "User";
                }
            }
            this.stringCell(level, style, 1, annotation);
        }
    }
}

