/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.synthesis;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.synthesis.SphereSynthesis;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Sphere;

public class Synthesis {
    private final SortedMap<String, BdfServer> fichothequeMap;
    private final SortedMap<String, SphereSynthesis> synthesisMap;

    private Synthesis(SortedMap<String, BdfServer> fichothequeMap, SortedMap<String, SphereSynthesis> synthesisMap) {
        this.fichothequeMap = fichothequeMap;
        this.synthesisMap = synthesisMap;
    }

    public SphereSynthesis[] getSphereSynthesisArray() {
        return this.synthesisMap.values().toArray(new SphereSynthesis[this.synthesisMap.size()]);
    }

    public BdfServer[] getBdfServerArray() {
        return this.fichothequeMap.values().toArray(new BdfServer[this.fichothequeMap.size()]);
    }

    public BdfServer getBdfServer(String name) {
        return (BdfServer)this.fichothequeMap.get(name);
    }

    public static class Builder {
        private final SortedMap<String, BdfServer> fichothequeMap = new TreeMap<String, BdfServer>();
        private final SortedMap<String, SphereSynthesis> synthesisMap = new TreeMap<String, SphereSynthesis>();

        public void addFichotheque(BdfServer bdfServer) {
            String name = bdfServer.getName();
            Fichotheque fichotheque = bdfServer.getFichotheque();
            for (Sphere sphere : fichotheque.getSphereList()) {
                SubsetKey sphereKey = sphere.getSubsetKey();
                String sphereName = sphereKey.getSubsetName();
                SphereSynthesis current = (SphereSynthesis)this.synthesisMap.get(sphereName);
                if (current == null) {
                    current = new SphereSynthesis(sphereKey);
                    this.synthesisMap.put(sphereName, current);
                }
                current.addSphere(bdfServer, sphere);
                this.fichothequeMap.put(name, bdfServer);
            }
        }

        public Synthesis toSynthesis() {
            return new Synthesis(new TreeMap<String, BdfServer>(this.fichothequeMap), new TreeMap<String, SphereSynthesis>(this.synthesisMap));
        }
    }
}

