/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.roles.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class RedacteurListDOMReader {
    private final MessageHandler messageHandler;
    private final Fichotheque fichotheque;

    public RedacteurListDOMReader(MessageHandler messageHandler, Fichotheque fichotheque) {
        this.messageHandler = messageHandler;
        this.fichotheque = fichotheque;
    }

    public List<Redacteur> readRedacteurList(Element element) {
        LinkedHashSet set = new LinkedHashSet();
        DOMUtils.readChildren(element, new RootConsumer(set));
        return new ArrayList<Redacteur>(set);
    }

    private Redacteur getRedacteur(Element element) {
        String sphereString = element.getAttribute("sphere");
        try {
            SubsetKey sphereKey = SubsetKey.parse((short)3, sphereString);
            Sphere sphere = (Sphere)this.fichotheque.getSubset(sphereKey);
            if (sphere != null) {
                String idString = element.getAttribute("id");
                if (idString.length() == 0) {
                    idString = element.getAttribute("idsph");
                }
                if (idString.length() > 0) {
                    try {
                        int id = Integer.parseInt(idString);
                        return sphere.getRedacteurById(id);
                    }
                    catch (NumberFormatException id) {
                    }
                } else {
                    String loginString = element.getAttribute("login");
                    if (loginString.length() > 0) {
                        return sphere.getRedacteurByLogin(loginString);
                    }
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final Set<Redacteur> set;

        private RootConsumer(Set<Redacteur> set) {
            this.set = set;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "redacteur": {
                    Redacteur redacteur = RedacteurListDOMReader.this.getRedacteur(element);
                    if (redacteur == null) break;
                    this.set.add(redacteur);
                    break;
                }
                default: {
                    DomMessages.unknownTagWarning(RedacteurListDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }
}

