/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.providers;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.providers.HtmlProducerProvider;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.logging.ErrorMessageException;

public class MultiHtmlProducerProviderBuilder {
    private final List<HtmlProducerProvider> providerList = new ArrayList<HtmlProducerProvider>();

    public void addHtmlProducerProvider(HtmlProducerProvider htmlProducerProvider) {
        if (htmlProducerProvider instanceof MultiHtmlProducerProvider) {
            HtmlProducerProvider[] array = ((MultiHtmlProducerProvider)htmlProducerProvider).array;
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                this.providerList.add(array[i]);
            }
        } else {
            this.providerList.add(htmlProducerProvider);
        }
    }

    public HtmlProducerProvider toHtmlProducerProvider() {
        int size = this.providerList.size();
        return new MultiHtmlProducerProvider(this.providerList.toArray(new HtmlProducerProvider[size]));
    }

    private static class MultiHtmlProducerProvider
    implements HtmlProducerProvider {
        private HtmlProducerProvider[] array;

        private MultiHtmlProducerProvider(HtmlProducerProvider[] array) {
            this.array = array;
        }

        @Override
        public HtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
            int length = this.array.length;
            for (int i = 0; i < length; ++i) {
                HtmlProducer htmlProducer = this.array[i].getHtmlProducer(parameters);
                if (htmlProducer == null) continue;
                return htmlProducer;
            }
            return null;
        }
    }
}

