/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.overview;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.overview.OverviewBlock;
import fr.exemole.bdfserver.tools.ui.components.DataUiBuilder;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LineMessageException;

class ExternalDataBlock
extends OverviewBlock {
    private final DataUiBuilder builder;

    ExternalDataBlock(int lineNumber, DataUi dataUi) {
        super(lineNumber, dataUi);
        this.builder = DataUiBuilder.init(dataUi);
    }

    ExternalDataBlock(int lineNumber, String dataName, String type) {
        super(lineNumber, dataName);
        this.builder = new DataUiBuilder(dataName, type);
    }

    @Override
    public boolean addText(String name, Lang lang, String text) {
        if (!this.isValidText(name)) {
            return false;
        }
        this.builder.getLabelChangeBuilder().putLabel(lang, text);
        return true;
    }

    @Override
    public void put(int lineNumber, String key, String value) throws LineMessageException {
        switch (key) {
            case "type": {
                break;
            }
            default: {
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
            }
        }
    }

    @Override
    public void put(int lineNumber, String key, String name, String value) throws LineMessageException {
        switch (key) {
            case "param": {
                this.builder.getExternalSourceDefBuilder().addParam(name, value);
                return;
            }
        }
        throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
    }

    private boolean isValidText(String labelName) {
        switch (labelName) {
            case "label": {
                return true;
            }
        }
        return false;
    }

    @Override
    public AttributeChangeBuilder getAttributeChangeBuilder() {
        return this.builder.getAttributeChangeBuilder();
    }

    @Override
    public void firstPass(EditSession editSession, UiComponents uiComponents) {
        editSession.getBdfServerEditor().putComponentUi(uiComponents, this.builder.toDataUi());
    }

    @Override
    public void secondPass(EditSession editSession, UiComponents uiComponents) {
    }
}

