/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.importation;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.importation.engines.CorpusImportEngine;
import fr.exemole.bdfserver.tools.importation.engines.LabelImportEngine;
import fr.exemole.bdfserver.tools.importation.engines.ThesaurusImportEngine;
import java.io.File;
import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.fiche.HtmlConverter;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.importation.ImportationContext;
import net.fichotheque.importation.LabelImport;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.LabelImportBuilder;
import net.fichotheque.tools.importation.corpus.CorpusImportBuilder;
import net.fichotheque.tools.importation.directory.CorpusImportLoad;
import net.fichotheque.tools.importation.dom.CorpusImportDOMReader;
import net.fichotheque.tools.importation.dom.ImportationDomUtils;
import net.fichotheque.tools.importation.dom.LabelImportDOMReader;
import net.fichotheque.tools.importation.dom.ThesaurusImportDOMReader;
import net.fichotheque.tools.importation.thesaurus.ThesaurusImportBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public final class ImportationEngine {
    public static final String LABEL_IMPORT = "labelimport";
    public static final String THESAURUS_IMPORT = "thesaurusimport";
    public static final String CORPUS_IMPORT = "corpusimport";

    private ImportationEngine() {
    }

    public static void run(EditSession editSession, BdfParameters bdfParameters, String engineType, File source) {
        Fichotheque fichotheque = bdfParameters.getFichotheque();
        switch (engineType) {
            case "labelimport": {
                Element rootElement = DOMUtils.readDocument(source).getDocumentElement();
                String langString = rootElement.getAttribute("lang");
                try {
                    Lang lang = Lang.parse(langString);
                    LabelImportBuilder builder = new LabelImportBuilder(lang);
                    LabelImportDOMReader.init(fichotheque, builder).read(rootElement);
                    LabelImport labelImport = builder.toLabelImport();
                    LabelImportEngine.runLabelImport(editSession, labelImport);
                }
                catch (ParseException lang) {}
                break;
            }
            case "thesaurusimport": {
                Element rootElement = DOMUtils.readDocument(source).getDocumentElement();
                ThesaurusImportBuilder thesaurusImportBuilder = ImportationDomUtils.buildThesaurusImportBuilder(fichotheque, rootElement);
                if (thesaurusImportBuilder == null) break;
                ThesaurusImportDOMReader.init(thesaurusImportBuilder).read(rootElement);
                ThesaurusImportEngine.runThesaurusImport(editSession, bdfParameters, thesaurusImportBuilder.toThesaurusImport());
                break;
            }
            case "corpusimport": {
                CorpusImport corpusImport = null;
                HtmlConverter htmlConverter = BdfServerUtils.DEFAULT_HTMLCONVERTER;
                ImportationContext importationContext = ImportationUtils.toImportationContext(bdfParameters.getHtmlCleaner(), htmlConverter);
                if (source.isDirectory()) {
                    corpusImport = CorpusImportLoad.load(fichotheque, source, importationContext);
                } else {
                    Element rootElement = DOMUtils.readDocument(source).getDocumentElement();
                    CorpusImportBuilder corpusImportBuilder = ImportationDomUtils.buildCorpusImportBuilder(fichotheque, rootElement);
                    if (corpusImportBuilder != null) {
                        CorpusImportDOMReader.init(corpusImportBuilder, importationContext).read(rootElement);
                        corpusImport = corpusImportBuilder.toCorpusImport();
                    }
                }
                if (corpusImport == null) break;
                CorpusImportEngine.runCorpusImport(editSession, bdfParameters, corpusImport);
                break;
            }
        }
    }

    public static boolean isValidEngineType(String engineType) {
        switch (engineType) {
            case "labelimport": 
            case "thesaurusimport": 
            case "corpusimport": {
                return true;
            }
        }
        return false;
    }
}

