/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormElement;
import fr.exemole.bdfserver.api.ficheform.FormElementProvider;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.builders.AddendaIncludeElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.AlbumIncludeElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.AmountInfoSubfieldsElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.AmountPropSubfieldsElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.CorpusIncludeElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.GeopointPropSubfieldsElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.ImagePropSubfieldsElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.LangFieldElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.PersonnePropSubfieldElementBuilder;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.CorpusMetadataUtils;

public final class FormElementProviderFactory {
    private FormElementProviderFactory() {
    }

    public static FormElementProvider newInstance(OutputParameters outputParameters) {
        return FormElementProviderFactory.newInstance(FicheFormUtils.toFicheFormParameters(outputParameters));
    }

    public static FormElementProvider newInstance(FicheFormParameters ficheFormParameters) {
        return new InternalFormElementProvider(ficheFormParameters);
    }

    private static class InternalFormElementProvider
    implements FormElementProvider {
        private final FicheFormParameters ficheFormParameters;

        public InternalFormElementProvider(FicheFormParameters ficheFormParameters) {
            this.ficheFormParameters = ficheFormParameters;
        }

        @Override
        public FormElement.Include getFormElement(FichePointeur fichePointeur, IncludeUi includeUi) {
            if (includeUi instanceof SpecialIncludeUi) {
                SpecialIncludeUi specialIncludeUi = (SpecialIncludeUi)includeUi;
                if (!FicheFormUtils.hasAccess(this.ficheFormParameters, specialIncludeUi)) {
                    return null;
                }
                switch (specialIncludeUi.getName()) {
                    case "liage": {
                        CorpusIncludeElementBuilder cieb = CorpusIncludeElementBuilder.check(fichePointeur, this.ficheFormParameters, specialIncludeUi);
                        if (cieb != null) {
                            return cieb.toCorpusIncludeElement();
                        }
                        return null;
                    }
                    case "parentage": {
                        return null;
                    }
                }
                return null;
            }
            if (includeUi instanceof SubsetIncludeUi) {
                SubsetIncludeUi subsetIncludeUi = (SubsetIncludeUi)includeUi;
                if (!FicheFormUtils.hasAccess(this.ficheFormParameters, subsetIncludeUi)) {
                    return null;
                }
                switch (subsetIncludeUi.getCategory()) {
                    case 4: {
                        AddendaIncludeElementBuilder adieb = AddendaIncludeElementBuilder.check(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                        if (adieb != null) {
                            return adieb.toAddendaIncludeElement();
                        }
                        return null;
                    }
                    case 5: {
                        AlbumIncludeElementBuilder alieb = AlbumIncludeElementBuilder.check(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                        if (alieb != null) {
                            return alieb.toAlbumIncludeElement();
                        }
                        return null;
                    }
                    case 1: {
                        CorpusIncludeElementBuilder cieb = CorpusIncludeElementBuilder.check(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                        if (cieb != null) {
                            return cieb.toCorpusIncludeElement();
                        }
                        return null;
                    }
                    case 2: {
                        return FicheFormUtils.toThesaurusIncludeElement(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public FormElement.Field getFormElement(FichePointeur fichePointeur, FieldUi fieldUi) {
            Object builder;
            CorpusField corpusField = FicheFormUtils.getCorpusField(fichePointeur, fieldUi);
            if (corpusField == null) {
                return null;
            }
            if (corpusField.isGenerated()) {
                return null;
            }
            if (!FicheFormUtils.hasAccess(this.ficheFormParameters, fieldUi)) {
                return null;
            }
            switch (corpusField.getFieldString()) {
                case "id": {
                    return null;
                }
                case "lang": {
                    return LangFieldElementBuilder.build(fichePointeur, this.ficheFormParameters, corpusField, fieldUi).toLangFieldElement();
                }
            }
            if (corpusField.isProp() && corpusField.isSubfieldDisplay()) {
                switch (corpusField.getFicheItemType()) {
                    case "person": {
                        PersonnePropSubfieldElementBuilder builder2 = PersonnePropSubfieldElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                        if (builder2 != null) {
                            return builder2.toPersonnePropSubfieldsElement();
                        }
                        return null;
                    }
                    case "geopoint": {
                        GeopointPropSubfieldsElementBuilder builder3 = GeopointPropSubfieldsElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                        if (builder3 != null) {
                            return builder3.toGeopointPropSubfieldsElement();
                        }
                        return null;
                    }
                    case "image": {
                        ImagePropSubfieldsElementBuilder builder4 = ImagePropSubfieldsElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                        if (builder4 != null) {
                            return builder4.toImagePropSubfieldsElement();
                        }
                        return null;
                    }
                }
            }
            if (CorpusMetadataUtils.isCurrenciesProp(corpusField)) {
                builder = AmountPropSubfieldsElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                if (builder != null) {
                    return ((AmountPropSubfieldsElementBuilder)builder).toAmountPropSubfieldsElement();
                }
                return null;
            }
            if (CorpusMetadataUtils.isCurrenciesInfo(corpusField)) {
                builder = AmountInfoSubfieldsElementBuilder.check(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
                if (builder != null) {
                    return ((AmountInfoSubfieldsElementBuilder)builder).toAmountInfoSubfieldsElement();
                }
                return null;
            }
            return FicheFormUtils.toFormElement(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
        }
    }
}

