/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.table;

import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.format.SubsetPathKey;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.format.FichothequeFormatDefBuilder;
import net.fichotheque.utils.TableDefUtils;

public final class BdfColDefs {
    private BdfColDefs() {
    }

    public static FormatColDef chrono(FichothequeFormatDefBuilder formatDefBuilder, String name, String patternMode) {
        formatDefBuilder.addSource(FormatSourceKey.newSpecialIncludeNameInstance(name));
        switch (patternMode) {
            case "standard": 
            case "code": {
                formatDefBuilder.addFormatPattern("{iso}");
                formatDefBuilder.setCastType((short)3);
                break;
            }
            case "formsyntax": {
                formatDefBuilder.addFormatPattern("{formsyntax}");
                break;
            }
            case "label": {
                formatDefBuilder.addFormatPattern("{label}");
            }
        }
        return TableDefUtils.toFormatColDef(name, formatDefBuilder.toFichothequeFormatDef());
    }

    public static FormatColDef liage(FichothequeFormatDefBuilder formatDefBuilder, String patternMode) {
        formatDefBuilder.addSource(FormatSourceKey.newSpecialIncludeNameInstance("liage"));
        switch (patternMode) {
            case "standard": 
            case "label": {
                formatDefBuilder.addFormatPattern("{title}");
                formatDefBuilder.putStringValue("sep", ", ");
                break;
            }
            case "code": {
                formatDefBuilder.addFormatPattern("{corpus}/{id}");
                break;
            }
            case "formsyntax": {
                formatDefBuilder.addFormatPattern("{formsyntax}");
            }
        }
        return TableDefUtils.toFormatColDef("liage", formatDefBuilder.toFichothequeFormatDef());
    }

    public static FormatColDef corpusField(FichothequeFormatDefBuilder formatDefBuilder, CorpusField corpusField, String patternMode) {
        formatDefBuilder.addSource(FormatSourceKey.newFieldKeyInstance(corpusField.getFieldKey()));
        if (BdfColDefs.isWithIntegerCast(corpusField)) {
            formatDefBuilder.setCastType((short)1);
        }
        switch (patternMode) {
            case "formsyntax": {
                formatDefBuilder.addFormatPattern("{formsyntax}");
                break;
            }
            case "standard": {
                if (BdfColDefs.isWithSeparator(corpusField)) {
                    formatDefBuilder.putStringValue("sep", ", ");
                }
                switch (corpusField.getFicheItemType()) {
                    case "amount": {
                        formatDefBuilder.addFormatPattern("{code}");
                        formatDefBuilder.setCastType((short)4);
                        break;
                    }
                    case "number": {
                        formatDefBuilder.addFormatPattern("{label}");
                    }
                }
                break;
            }
            case "label": {
                if (BdfColDefs.isWithSeparator(corpusField)) {
                    formatDefBuilder.putStringValue("sep", ", ");
                }
                switch (corpusField.getFicheItemType()) {
                    case "amount": 
                    case "number": 
                    case "country": 
                    case "language": 
                    case "date": {
                        formatDefBuilder.addFormatPattern("{label}");
                    }
                }
                break;
            }
            case "code": {
                switch (corpusField.getFicheItemType()) {
                    case "amount": 
                    case "number": 
                    case "country": 
                    case "language": {
                        formatDefBuilder.addFormatPattern("{code}");
                    }
                }
            }
        }
        return TableDefUtils.toFormatColDef(corpusField.getFieldString(), formatDefBuilder.toFichothequeFormatDef());
    }

    public static FormatColDef subsetIncludeField(FichothequeFormatDefBuilder formatDefBuilder, ExtendedIncludeKey includeKey, String patternMode, Fichotheque fichotheque, SubsetPathKey masterPath) {
        if (includeKey.isMaster() && masterPath != null) {
            formatDefBuilder.addSource(FormatSourceKey.newIncludeKeyInstance(includeKey.getRootIncludeKey(), masterPath));
        } else {
            formatDefBuilder.addSource(FormatSourceKey.newIncludeKeyInstance(includeKey.getRootIncludeKey()));
        }
        SubsetKey subsetKey = includeKey.getSubsetKey();
        if (subsetKey.isThesaurusSubset()) {
            boolean isIdalpha = BdfColDefs.isIdalpha(fichotheque, subsetKey);
            switch (patternMode) {
                case "standard": 
                case "label": {
                    if (isIdalpha) {
                        formatDefBuilder.addFormatPattern("{idalpha} \u2013 {label}");
                        break;
                    }
                    formatDefBuilder.addFormatPattern("{label}");
                    break;
                }
                case "code": {
                    if (isIdalpha) {
                        formatDefBuilder.addFormatPattern("{idalpha}");
                        break;
                    }
                    formatDefBuilder.addFormatPattern("{id}");
                    break;
                }
                case "formsyntax": {
                    formatDefBuilder.addFormatPattern("{formsyntax}");
                }
            }
        } else if (subsetKey.isCorpusSubset()) {
            switch (patternMode) {
                case "standard": 
                case "label": {
                    formatDefBuilder.addFormatPattern("{title}");
                    formatDefBuilder.putStringValue("sep", ", ");
                    break;
                }
                case "code": {
                    formatDefBuilder.addFormatPattern("{id}");
                    break;
                }
                case "formsyntax": {
                    formatDefBuilder.addFormatPattern("{formsyntax}");
                }
            }
        } else {
            switch (patternMode) {
                case "standard": 
                case "code": 
                case "label": {
                    break;
                }
                case "formsyntax": {
                    formatDefBuilder.addFormatPattern("{formsyntax}");
                }
            }
        }
        return TableDefUtils.toFormatColDef(includeKey.getKeyString(), formatDefBuilder.toFichothequeFormatDef());
    }

    private static boolean isWithSeparator(CorpusField corpusField) {
        switch (corpusField.getCategory()) {
            case 2: {
                return true;
            }
            case 0: {
                switch (corpusField.getFieldString()) {
                    case "owners": {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isWithIntegerCast(CorpusField corpusField) {
        switch (corpusField.getFieldString()) {
            case "id": {
                return true;
            }
        }
        return false;
    }

    private static boolean isIdalpha(Fichotheque fichotheque, SubsetKey subsetKey) {
        Thesaurus thesaurus = (Thesaurus)fichotheque.getSubset(subsetKey);
        if (thesaurus != null) {
            return thesaurus.isIdalphaType();
        }
        return false;
    }
}

