/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine.runners;

import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.balayage.engine.EngineUtils;
import fr.exemole.bdfserver.tools.balayage.engine.runners.AbstractOutputRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.utils.AlbumUtils;
import net.fichotheque.utils.BalayageUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.text.AccoladeArgument;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.ValueResolver;

public class IllustrationOutputRunner
extends AbstractOutputRunner {
    private static final short NOSPECIALDIM = 0;
    private final AccoladePattern pattern;

    public IllustrationOutputRunner(BalayageParameters balayageParameters, int outputIndex, BalayageOutput output, int balayageUnitIndex) {
        super(balayageParameters, outputIndex, output, balayageUnitIndex);
        this.pattern = BalayageUtils.getPattern(output, "illustration");
    }

    public void copy(Album album, List<String> albumDimNameList, long startTime) {
        if (albumDimNameList.isEmpty()) {
            this.copyFiles(album, null, (short)202);
        } else {
            for (String albumDimName : albumDimNameList) {
                if (albumDimName.equals("_mini")) {
                    this.copyFiles(album, null, (short)201);
                    continue;
                }
                AlbumDim albumDim = album.getAlbumMetadata().getAlbumDimByName(albumDimName);
                if (albumDim == null) continue;
                this.copyFiles(album, albumDim, (short)0);
            }
        }
    }

    private void copyFiles(Album album, AlbumDim albumDim, short specialDim) {
        IllustrationValueResolver valueResolver = new IllustrationValueResolver(album, albumDim, specialDim);
        File directory = this.rootDirectory;
        String path = EngineUtils.getPath(this.output, valueResolver);
        if (path != null) {
            directory = new File(directory, path);
        }
        this.prepareDirectory(directory);
        for (Illustration illustration : album.getIllustrationList()) {
            valueResolver.setIllustration(illustration);
            String fileName = this.pattern.format(valueResolver) + "." + illustration.getFormatTypeString();
            File destination = new File(directory, fileName);
            InputStream inputStream = albumDim != null ? illustration.getInputStream(albumDim) : illustration.getInputStream(specialDim);
            try {
                InputStream is = inputStream;
                try (FileOutputStream os = new FileOutputStream(destination);){
                    IOUtils.copy(is, (OutputStream)os);
                    this.balayageLog.addFileGeneration(this.balayageUnitIndex, this.outputIndex, destination);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                String message = ioe.getClass().getName();
                if (msg != null) {
                    message = message + " : " + msg;
                }
                this.balayageLog.addOutputError(this.balayageUnitIndex, this.outputIndex, this.output, "ioException", destination.getName(), message);
            }
        }
    }

    private static class IllustrationValueResolver
    implements ValueResolver {
        private final Album album;
        private final AlbumDim albumDim;
        private final short specialDim;
        private Illustration illustration;

        private IllustrationValueResolver(Album album, AlbumDim albumDim, short specialDim) {
            this.album = album;
            this.albumDim = albumDim;
            this.specialDim = specialDim;
        }

        @Override
        public String getValue(AccoladeArgument patternArgument) {
            String patternArgumentName = patternArgument.getName();
            if (patternArgumentName.equals("album")) {
                return this.album.getSubsetName();
            }
            if (patternArgumentName.equals("albumdim")) {
                if (this.albumDim == null) {
                    return AlbumUtils.specialDimToString(this.specialDim);
                }
                return this.albumDim.getName();
            }
            if ((patternArgumentName.equals("id") || patternArgumentName.equals("idalbum")) && this.illustration != null) {
                return String.valueOf(this.illustration.getId());
            }
            return AccoladePattern.toString(patternArgument);
        }

        private void setIllustration(Illustration illustration) {
            this.illustration = illustration;
        }
    }
}

