/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.TreeStorage;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import fr.exemole.bdfserver.tools.subsettree.SubsetTreeBuilder;
import fr.exemole.bdfserver.tools.subsettree.dom.TreeDOMReader;
import fr.exemole.bdfserver.xml.subsettree.TreeXMLPart;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;

public class TreeStorageImpl
implements TreeStorage {
    private final StorageDirectory bdfdataDirectory;
    private final String rootPath = "conf" + File.separator + "trees";

    public TreeStorageImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    @Override
    public void saveSubsetTree(short subsetCategory, SubsetTree subsetTree) {
        StorageFile storageFile = this.getTreeFile(subsetCategory);
        try (BufferedWriter buf = storageFile.getWriter();){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            TreeXMLPart xmlPart = new TreeXMLPart(xmlWriter);
            xmlPart.addTree(subsetTree);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public Map<Short, SubsetTree> check(MultiMessageHandler messageHandler) {
        HashMap<Short, SubsetTree> result = new HashMap<Short, SubsetTree>();
        File treesDirectory = this.bdfdataDirectory.getDataDir(this.rootPath);
        if (!treesDirectory.exists()) {
            return result;
        }
        for (File f : treesDirectory.listFiles()) {
            String fileName;
            if (f.isDirectory() || !(fileName = f.getName()).endsWith(".xml")) continue;
            try {
                SubsetTreeBuilder subsetTreeBuilder = new SubsetTreeBuilder(true);
                short category = SubsetKey.categoryToShort(fileName.substring(0, fileName.length() - 4));
                StorageFile storageFile = this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + fileName);
                messageHandler.setCurrentSource(storageFile.toURI());
                Document doc = storageFile.readDocument();
                TreeDOMReader treeDOMReader = new TreeDOMReader(subsetTreeBuilder, messageHandler);
                treeDOMReader.readTree(doc.getDocumentElement());
                result.put(category, subsetTreeBuilder.toSubsetTree());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    private StorageFile getTreeFile(short subsetCategory) {
        return this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + SubsetKey.categoryToString(subsetCategory) + ".xml");
    }
}

