/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.Remove;
import fr.exemole.bdfserver.storage.directory.bdfdata.Save;
import net.fichotheque.EditOrigin;
import net.fichotheque.impl.ThesaurusDataSource;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;

public class ThesaurusDataSourceImpl
implements ThesaurusDataSource {
    private StorageDirectory bdfdataDirectory;

    public ThesaurusDataSourceImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    @Override
    public void saveMetadata(Thesaurus thesaurus, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Save.saveThesaurusMetadata(this.bdfdataDirectory, thesaurus, editOrigin);
    }

    @Override
    public void saveTree(Thesaurus thesaurus, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Save.saveThesaurusTree(this.bdfdataDirectory, thesaurus, editOrigin);
    }

    @Override
    public void saveMotcle(Motcle motcle, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Save.saveMotcle(this.bdfdataDirectory, motcle, editOrigin);
    }

    @Override
    public void removeMotcle(Thesaurus thesaurus, int id, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeMotcle(this.bdfdataDirectory, thesaurus, id, editOrigin);
    }
}

