/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class StatusInFichothequeChangeCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "StatusInFichothequeChange";

    public StatusInFichothequeChangeCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        this.initCentralSphere();
        this.initCentralUser();
        this.initBdfServer(true);
        Redacteur redacteur = this.getRedacteur();
        this.checkLastAdmin(redacteur);
        BdfServer bdfServer = this.getBdfServer();
        synchronized (bdfServer) {
            try (EditSession editSession = this.newEditSession(COMMAND_NAME);){
                SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(this.centralSphere.getSphereKey());
                this.changeStatus(redacteur, sphereEditor, editSession);
            }
        }
        return this.done("_ done.sphere.redacteurstatus");
    }

    private void checkLastAdmin(Redacteur redacteur) throws ErrorMessageException {
        PermissionManager permissionManager = this.bdfServer.getPermissionManager();
        if (permissionManager.isAdmin(redacteur) && permissionManager.getAdminRedacteurList().size() == 1) {
            throw BdfErrors.error("_ error.unsupported.lastadmin", redacteur.getLogin());
        }
    }
}

