/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.misc;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.jsonproducers.misc.FicheRevisionsJsonProducer;
import fr.exemole.bdfserver.jsonproducers.misc.FichesGeoJsonProducer;
import fr.exemole.bdfserver.jsonproducers.misc.HistoryJsonProducer;
import fr.exemole.bdfserver.jsonproducers.misc.MementoUnitInfoArrayJsonProducer;
import fr.exemole.bdfserver.jsonproducers.misc.MementoUnitJsonProducer;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.Set;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.history.FicheHistory;
import net.fichotheque.history.HistoryUnit;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;

public final class MiscJsonProducerFactory {
    private MiscJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        String json;
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        switch (json = parameters.getOutput()) {
            case "fichesgeo": {
                return new FichesGeoJsonProducer(parameters);
            }
            case "history": {
                FicheHistory ficheHistory;
                Subset subset = requestHandler.getMandatorySubset();
                int id = requestHandler.getMandatoryId();
                PermissionChecker.init(parameters).checkHistory(subset, id);
                HistoryUnit history = null;
                if (subset instanceof Corpus && (ficheHistory = ((Corpus)subset).getFicheHistory(id)) != null) {
                    history = ficheHistory.getFicheUnit();
                }
                return new HistoryJsonProducer(parameters, history);
            }
            case "memento-unit": {
                RelativePath mementoPath = MiscJsonProducerFactory.getPath(requestHandler);
                return new MementoUnitJsonProducer(parameters, mementoPath);
            }
            case "memento-unitinfo-array": {
                return new MementoUnitInfoArrayJsonProducer(parameters);
            }
            case "revisions-fiche": {
                Corpus corpus = requestHandler.getMandatoryCorpus();
                int id = requestHandler.getMandatoryId();
                PermissionChecker.init(parameters).checkHistory(corpus, id);
                Set<String> revisionNameSet = MiscJsonProducerFactory.getRevisionNameArray(requestHandler);
                return new FicheRevisionsJsonProducer(corpus, id, revisionNameSet);
            }
        }
        return null;
    }

    private static Set<String> getRevisionNameArray(RequestHandler requestHandler) throws ErrorMessageException {
        String revisionsParam = requestHandler.getMandatoryParameter("revisions");
        String[] revisions = StringUtils.getTechnicalTokens(revisionsParam, true);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String revision : revisions) {
            set.add(revision);
        }
        return set;
    }

    private static RelativePath getPath(RequestHandler requestHandler) throws ErrorMessageException {
        String path = requestHandler.getMandatoryParameter("path");
        try {
            return RelativePath.parse(path);
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue("path", path);
        }
    }
}

