/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.main;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.jsonproducers.main.AvailablePatternsJsonProperty;
import fr.exemole.bdfserver.jsonproducers.main.TableJsonProperty;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import net.fichotheque.Subset;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.extraction.ExtractionContext;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.logging.ErrorMessageException;

public final class MainJsonProducerFactory {
    private MainJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        String json = parameters.getOutput();
        ResultJsonProducer jsonProducer = new ResultJsonProducer(parameters);
        JsonProperty jsonProperty = MainJsonProducerFactory.getJsonProperty(parameters, json);
        if (jsonProperty == null) {
            return null;
        }
        jsonProducer.add(jsonProperty);
        return jsonProducer;
    }

    public static JsonProperty getJsonProperty(OutputParameters parameters, String name) throws ErrorMessageException {
        switch (name) {
            case "availablepatterns": {
                return new AvailablePatternsJsonProperty(parameters.getBdfServer(), parameters.getBdfUser());
            }
            case "table": {
                return MainJsonProducerFactory.getTableJsonProperty(parameters);
            }
        }
        return null;
    }

    private static JsonProperty getTableJsonProperty(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        BdfServer bdfServer = parameters.getBdfServer();
        Subset subset = requestHandler.getMandatorySubset();
        if (!parameters.getPermissionSummary().hasAccess(subset)) {
            return null;
        }
        TableExportManager manager = bdfServer.getTableExportManager();
        SubsetTable subsetTable = null;
        TableExportDef tableExportDef = null;
        String tableExportName = requestHandler.getTrimedParameter("tableexport");
        if (!tableExportName.isEmpty()) {
            TableExport tableExport = manager.getTableExport(tableExportName);
            if (tableExport != null) {
                tableExportDef = tableExport.getTableExportDef();
                subsetTable = tableExport.getSubsetTable(subset.getSubsetKey());
            }
            if (subsetTable == null) {
                throw BdfErrors.error("_ tableexport_err_notableexportcontent", tableExportName, subset.getSubsetKeyString());
            }
        } else {
            subsetTable = BdfTableExportUtils.toDefaultSubsetTable(bdfServer, subset, parameters.getBdfUser().getPrefs().getDefaultFicheTableParameters(), parameters.getPermissionSummary());
        }
        TableExportContext tableExportContext = bdfServer.getTableExportContext();
        ExtractionContext extractionContext = parameters.getDefaultExtractionContext();
        SumCellConverter cellConverter = BdfTableExportUtils.toCellConverter(bdfServer, extractionContext, subsetTable, tableExportDef);
        return new TableJsonProperty(bdfServer, parameters.getBdfUser(), subsetTable, tableExportContext, cellConverter);
    }
}

