/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.main;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.json.PatternDefJson;
import java.io.IOException;
import java.util.List;
import net.fichotheque.format.PatternDef;
import net.fichotheque.tools.format.patterndefs.PatternDefs;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;

public class AvailablePatternsJsonProperty
implements JsonProperty {
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;

    public AvailablePatternsJsonProperty(BdfServer bdfServer, BdfUser bdfUser) {
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
    }

    @Override
    public String getName() {
        return "availablePatterns";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        jw.object();
        this.valueProperties(jw);
        this.properties(jw, "person");
        this.properties(jw, "language");
        this.properties(jw, "date");
        this.properties(jw, "country");
        this.properties(jw, "number");
        this.properties(jw, "amount");
        this.properties(jw, "email");
        this.properties(jw, "link");
        this.properties(jw, "item");
        this.properties(jw, "geopoint");
        this.properties(jw, "para");
        this.properties(jw, "image");
        this.properties(jw, "section", PatternDefs.FICHEBLOCK);
        this.properties(jw, "fiche", PatternDefs.FICHEMETA);
        this.properties(jw, "motcle_multi", PatternDefs.MOTCLE_MULTI);
        this.properties(jw, "motcle_idalpha", PatternDefs.MOTCLE_IDALPHA);
        this.properties(jw, "motcle_babelien", PatternDefs.MOTCLE_BABELIEN);
        this.properties(jw, "illustration", PatternDefs.ILLUSTRATION);
        this.properties(jw, "document", PatternDefs.DOCUMENT);
        this.properties(jw, "extraction", PatternDefs.EXTRACTION);
        this.properties(jw, "idalpha", PatternDefs.IDALPHA);
        jw.endObject();
    }

    private void valueProperties(JSONWriter jw) throws IOException {
        jw.key("value");
        jw.array();
        jw.object();
        jw.key("name").value("value");
        jw.endObject();
        jw.endArray();
    }

    private void properties(JSONWriter jw, String ficheItemType) throws IOException {
        List<PatternDef> patternDefList = PatternDefs.ficheItem(ficheItemType);
        this.properties(jw, ficheItemType, patternDefList);
    }

    private void properties(JSONWriter jw, String key, List<PatternDef> patternDefList) throws IOException {
        jw.key(key);
        jw.array();
        for (PatternDef patternDef : patternDefList) {
            jw.object();
            PatternDefJson.properties(jw, patternDef, this.bdfServer);
            jw.endObject();
        }
        jw.endArray();
    }
}

