/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.managers.SqlExportManager;
import fr.exemole.bdfserver.api.storage.SqlExportStorage;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.exportation.sql.SqlExportDef;

class SqlExportManagerImpl
implements SqlExportManager {
    private static final List<SqlExportDef> EMPTY_LIST = Collections.emptyList();
    private final SqlExportStorage sqlExportStorage;
    private final SortedMap<String, SqlExportDef> sqlExportDefMap = new TreeMap<String, SqlExportDef>();
    private List<SqlExportDef> sqlExportDefList = EMPTY_LIST;

    SqlExportManagerImpl(SqlExportStorage sqlExportStorage) {
        this.sqlExportStorage = sqlExportStorage;
    }

    synchronized void check(List<SqlExportDef> sqlExportDefList) {
        this.sqlExportDefMap.clear();
        for (SqlExportDef scrutariExportDef : sqlExportDefList) {
            this.sqlExportDefMap.put(scrutariExportDef.getName(), scrutariExportDef);
        }
        this.updateList();
    }

    @Override
    public List<SqlExportDef> getSqlExportDefList() {
        return this.sqlExportDefList;
    }

    @Override
    public SqlExportDef getSqlExportDef(String name) {
        return (SqlExportDef)this.sqlExportDefMap.get(name);
    }

    @Override
    public synchronized void putSqlExportDef(SqlExportDef sqlExportDef) {
        String name = sqlExportDef.getName();
        this.sqlExportDefMap.put(name, sqlExportDef);
        this.updateList();
        this.sqlExportStorage.saveSqlExportDef(sqlExportDef);
    }

    @Override
    public synchronized void removeSqlExportDef(String name) {
        boolean here = this.sqlExportDefMap.containsKey(name);
        if (!here) {
            return;
        }
        this.sqlExportDefMap.remove(name);
        this.sqlExportStorage.removeSqlExportDef(name);
        this.updateList();
    }

    private void updateList() {
        this.sqlExportDefList = new SqlExportDefList(this.sqlExportDefMap.values().toArray(new SqlExportDef[this.sqlExportDefMap.size()]));
    }

    private static class SqlExportDefList
    extends AbstractList<SqlExportDef>
    implements RandomAccess {
        private final SqlExportDef[] array;

        private SqlExportDefList(SqlExportDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SqlExportDef get(int index) {
            return this.array[index];
        }
    }
}

