/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.configuration.LangConfiguration;
import fr.exemole.bdfserver.api.storage.ConfigurationStorage;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;

class LangConfigurationImpl
implements LangConfiguration {
    private final ConfigurationStorage configurationStorage;
    private Langs workingLangs = LangsUtils.toCleanLangs("fr");
    private Langs supplementaryLangs = LangsUtils.EMPTY_LANGS;
    private boolean allLanguages = false;
    private boolean withNonlatin = false;
    private boolean withoutSurnameFirst = false;

    LangConfigurationImpl(ConfigurationStorage configurationStorage) {
        this.configurationStorage = configurationStorage;
    }

    @Override
    public Langs getWorkingLangs() {
        return this.workingLangs;
    }

    @Override
    public Langs getSupplementaryLangs() {
        return this.supplementaryLangs;
    }

    @Override
    public boolean isAllLanguages() {
        return this.allLanguages;
    }

    @Override
    public boolean isWithNonlatin() {
        return this.withNonlatin;
    }

    @Override
    public boolean isWithoutSurnameFirst() {
        return this.withoutSurnameFirst;
    }

    void update(LangConfiguration langConfiguration) {
        this.workingLangs = LangsUtils.fromCollection(langConfiguration.getWorkingLangs());
        this.supplementaryLangs = LangsUtils.fromCollection(langConfiguration.getSupplementaryLangs());
        this.allLanguages = langConfiguration.isAllLanguages();
        this.withNonlatin = langConfiguration.isWithNonlatin();
        this.withoutSurnameFirst = langConfiguration.isWithoutSurnameFirst();
    }

    void save() {
        this.configurationStorage.saveLangConfiguration(this);
    }
}

