/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.sphere;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.SubsetTitle;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereHtmlUtils;
import fr.exemole.bdfserver.tools.BH;
import java.util.List;
import java.util.function.BiConsumer;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.tools.sphere.RedacteurStats;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinter;

public class RedacteurStatsHtmlProducer
extends BdfServerHtmlProducer {
    private final PermissionSummary permissionSummary;
    private final Redacteur redacteur;

    public RedacteurStatsHtmlProducer(BdfParameters bdfParameters, Redacteur redacteur) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.redacteur = redacteur;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.APPELANT);
        this.addThemeCss("sphere.css");
    }

    @Override
    public void printHtml() {
        this.start();
        SphereHtmlUtils.printRedacteurToolbar(this, "redacteur-stats", this.redacteur);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("sphere").family("SPH").veil(true).page("redacteur-stats");
        RedacteurStats redacteurStats = new RedacteurStats(this.redacteur);
        if (!redacteurStats.isEmpty()) {
            this.printRedacteurStats(redacteurStats);
            if (this.permissionSummary.isFichothequeAdmin()) {
                SphereCommandBoxUtils.printRedacteurReplaceBox(this, commandBox, this.redacteur);
            }
        } else {
            this.__(PageUnit.start("_ title.sphere.stats")).P().__localize("_ info.sphere.fiche_none")._P().__(PageUnit.END);
            commandBox.page("_message");
            SphereCommandBoxUtils.printRedacteurRemoveBox(this, commandBox, this.redacteur);
        }
        this.end();
    }

    private void printRedacteurStats(RedacteurStats redacteurStats) {
        int count = redacteurStats.getFicheCount();
        ByFicheBranch byFicheBranch = new ByFicheBranch();
        List<RedacteurStats.ByCorpusStats> byCorpusStatsList = redacteurStats.getByCorpusStatsList();
        this.__(PageUnit.start("_ title.sphere.stats")).P().__(() -> {
            if (count == 1) {
                this.__localize("_ info.sphere.fiche_one");
            } else {
                this.__localize("_ info.sphere.fiche_many", count);
            }
        })._P().__(Tree.TREE, () -> {
            for (RedacteurStats.ByCorpusStats byCorpusStats : byCorpusStatsList) {
                this.__(byFicheBranch, byCorpusStats);
            }
        }).__(PageUnit.END);
    }

    private class ByFicheBranch
    implements BiConsumer<HtmlPrinter, Object> {
        private ByFicheBranch() {
        }

        @Override
        public void accept(HtmlPrinter hp, Object object) {
            RedacteurStats.ByCorpusStats byCorpusStats = (RedacteurStats.ByCorpusStats)object;
            Corpus corpus = byCorpusStats.getCorpus();
            SubsetKey corpusKey = corpus.getSubsetKey();
            hp.__(Tree.OPEN_NODE, () -> hp.P().__(SubsetTitle.init(corpus, RedacteurStatsHtmlProducer.this.workingLang).subsetIcon(true).subsetName(true))._P().__(Tree.BRANCH, () -> {
                List<RedacteurStats.ByFicheStats> list = byCorpusStats.getByFicheStatsList();
                for (RedacteurStats.ByFicheStats byFicheStats : list) {
                    int id = byFicheStats.getId();
                    hp.__(Tree.LEAF, () -> {
                        hp.__escape(corpusKey.getSubsetName()).__escape('/').__append(id).__space().SPAN("global-SmallLinks").__escape('[');
                        int weight = byFicheStats.getWeight();
                        boolean premier = true;
                        if ((weight & 1) != 0) {
                            premier = false;
                            hp.__escape("owners");
                        }
                        if ((weight & 2) != 0) {
                            if (premier) {
                                premier = false;
                            } else {
                                hp.__escape(" - ");
                            }
                            hp.__escape("prop");
                        }
                        if ((weight & 4) != 0) {
                            if (premier) {
                                premier = false;
                            } else {
                                hp.__escape(" - ");
                            }
                            hp.__escape("info");
                        }
                        hp.__escape(']').__space().__escape('[').A(HA.href(BH.domain("edition").page("fiche-change").subset(corpus).param("id", String.valueOf(id)))).__localize("_ link.edition.fichechange_short")._A().__dash().A(HA.href("fiches/" + corpusKey.getSubsetName() + "-" + id + ".html")).__localize("_ link.global.display")._A().__escape(']')._SPAN();
                    });
                }
            }));
        }
    }
}

