/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.main;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.html.HA;

public class NoScriptMenuHtmlProducer
extends BdfServerHtmlProducer {
    private final Button linkButton = Button.link();

    public NoScriptMenuHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addThemeCss("menu.css");
        this.setBodyCssClass("global-body-TopBorder");
    }

    @Override
    public void printHtml() {
        this.start();
        this.DIV("menu-Container menu-NoScript").__(this.printLogoBlock()).__(this.printListBlock()).__(this.printAdminBlock()).__(this.printActionBlock()).__(this.printFicheBlock()).__(this.printGlue()).__(this.printSessionBlock())._DIV();
        this.end();
    }

    private boolean printLogoBlock() {
        String sessionString = this.getSessionString();
        this.DIV("menu-LogoBlock").IMG(HA.src("dyn-pub/images/icon32.svg").title(sessionString).alt(sessionString).width("32").height("32"))._DIV();
        return true;
    }

    private boolean printListBlock() {
        String fichesHref = BH.domain("main").page("fiches").param("reload", "1").toString();
        String collectionsHref = BH.domain("main").page("collections").toString();
        this.DIV("menu-ListBlock").__(this.listLink(fichesHref, "action-Fiches", "_ link.main.fiches")).__(this.listLink(collectionsHref, "action-Collections", "_ link.main.collections"))._DIV();
        return true;
    }

    private boolean printAdminBlock() {
        String selectionHref = BH.domain("selection").page("selectform").toString();
        String adminHref = BH.domain("administration").page("index").toString();
        this.DIV("menu-AdminBlock").__(this.editionLink(selectionHref, "action-Selection", "_ link.selection.form"));
        if (this.bdfParameters.isFichothequeAdmin() || this.bdfParameters.getPermissionSummary().isPartialAdmin()) {
            this.__(this.listLink(adminHref, "action-Admin", "_ link.administration.index"));
        } else {
            this.SPAN("menu-EmptySpace")._SPAN();
        }
        this._DIV();
        return true;
    }

    private boolean printActionBlock() {
        this.DIV("menu-ActionBlock").__(this.editionLink(BH.domain("misc").page("tableexportform").toString(), "action-Ods", "_ link.misc.ods_export")).__(this.editionLink(BH.domain("sphere").page("redacteur-userform").toString(), "action-Preferences", "_ link.sphere.userprefs"))._DIV();
        return true;
    }

    private boolean printFicheBlock() {
        SubsetTree filteredSubsetTree = TreeFilterEngine.read(this.bdfParameters.getPermissionSummary(), this.bdfServer.getTreeManager().getSubsetTree((short)1));
        if (filteredSubsetTree.getNodeList().isEmpty()) {
            return false;
        }
        this.DIV("menu-FicheBlock").DIV("menu-fiche-CreationForm").FORM_get("edition", "Edition").SELECT(HA.id("corpusSelect").name("corpus")).__(SubsetTreeOptions.init(filteredSubsetTree, this.bdfServer, this.workingLang).onlyNames(true).withKeys(false))._SELECT().__space().INPUT_hidden("page", "fiche-creation").__(Button.submit("_ link.edition.fichecreation"))._FORM()._DIV().DIV("menu-EmptySpace")._DIV()._DIV();
        return true;
    }

    private boolean printGlue() {
        this.DIV("global-Glue")._DIV();
        return true;
    }

    private boolean printSessionBlock() {
        Button button = Button.link().style("transparent");
        this.DIV("menu-SessionBlock").__(button.href(BH.domain("session").param("bdf-exit", "1").param("bdf-default-sphere", this.bdfUser.getRedacteur().getSubsetName())).action("action-SessionClose").tooltipMessage("_ link.session.new").target("_top")).__(button.href(BH.domain("session")).action("action-SessionDuplicate").tooltipMessage("_ link.session.duplicate").target("_blank"))._DIV();
        return true;
    }

    private Button listLink(String href, String action, String messageKey) {
        return this.linkButton.href(href).action(action).textL10nObject(messageKey).target("List");
    }

    private Button editionLink(String href, String action, String messageKey) {
        return this.linkButton.href(href).action(action).textL10nObject(messageKey).target("Edition");
    }

    private String getSessionString() {
        Redacteur redacteur = this.bdfUser.getRedacteur();
        StringBuilder buf = new StringBuilder();
        buf.append(this.getLocalization("_ label.menu.openby"));
        buf.append(" ");
        buf.append(redacteur.getCompleteName());
        buf.append(" \u2013 ");
        buf.append(redacteur.getBracketStyle());
        return buf.toString();
    }
}

