/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.mailing;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.commands.mailing.SendCommand;
import fr.exemole.bdfserver.email.EmailBuffer;
import fr.exemole.bdfserver.email.SendReport;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.mailing.SendFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.mailing.SendReportHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import net.mapeadores.util.logging.ErrorMessageException;

public final class MailingHtmlProducerFactory {
    private MailingHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String page = parameters.getOutput();
        BdfServer bdfServer = parameters.getBdfServer();
        switch (page) {
            case "send-form": {
                SendCommand.testSmtpManager(bdfServer);
                EmailBuffer emailBuffer = MailingHtmlProducerFactory.getEmailBuffer(requestHandler);
                return new SendFormHtmlProducer(parameters, emailBuffer);
            }
            case "send-report": {
                SendCommand.testSmtpManager(bdfServer);
                EmailBuffer emailBuffer = MailingHtmlProducerFactory.getEmailBuffer(requestHandler);
                SendReport sendReport = (SendReport)parameters.getResultObject("obj.sendreport");
                return new SendReportHtmlProducer(parameters, emailBuffer, sendReport);
            }
        }
        return null;
    }

    private static EmailBuffer getEmailBuffer(OutputRequestHandler requestHandler) throws ErrorMessageException {
        EmailBuffer emailBuffer = (EmailBuffer)requestHandler.getResultObject("obj.emailbuffer");
        if (emailBuffer == null) {
            emailBuffer = SendCommand.buildFromRequest(requestHandler, true);
        }
        return emailBuffer;
    }
}

