/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.importation;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.htmlproducers.importation.ImportationHtmlUtils;
import java.util.function.Consumer;
import net.fichotheque.importation.ParseResult;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.html.HtmlPrinter;

public class ImportationConfirmHtmlProducer
extends BdfServerHtmlProducer {
    private static final Consumer<HtmlPrinter> CONFIRM_SUBMIT = Button.submit("_ submit.importation.confirm");
    private final ParseResult parseResult;

    public ImportationConfirmHtmlProducer(BdfParameters bdfParameters, ParseResult parseResult) {
        super(bdfParameters);
        this.parseResult = parseResult;
        this.addJsLib(MiscJsLibs.IMPORTATION);
        this.addThemeCss("importation.css");
    }

    @Override
    public void printHtml() {
        this.start();
        this.printCommandMessageUnit();
        if (this.parseResult != null) {
            this.__(PageUnit.start("_ title.importation.confirm"));
            ImportationHtmlUtils.printParseResult(this, this.parseResult);
            String path = this.parseResult.getPath();
            if (!path.isEmpty() && this.parseResult.isAllCorrect()) {
                this.P().__localize("_ info.importation.allcorrect")._P();
                String type = this.parseResult.getType();
                ParameterMap parameterMap = ParameterMap.init().command("ImportationEngine").page(ImportationConfirmHtmlProducer.getPage(type)).param("type", type).param("root", "tmp").param("path", path);
                this.FORM_post("importation").INPUT_hidden(parameterMap).__(Button.COMMAND, CONFIRM_SUBMIT)._FORM();
            }
            this.__(PageUnit.END);
        }
        this.end();
    }

    private static String getPage(String type) {
        if (type.equals("labelimport")) {
            return "labelimport";
        }
        if (type.equals("thesaurusimport")) {
            return "thesaurusimport";
        }
        if (type.equals("corpusimport")) {
            return "corpusimport";
        }
        throw new SwitchException("Unknown type");
    }
}

