/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlUtils;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.html.CommandBox;

public class CorpusAdvancedCommandsHtmlProducer
extends BdfServerHtmlProducer {
    private final Corpus corpus;

    public CorpusAdvancedCommandsHtmlProducer(BdfParameters bdfParameters, Corpus corpus) {
        super(bdfParameters);
        this.corpus = corpus;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
        this.addThemeCss("corpus.css");
    }

    @Override
    public void printHtml() {
        this.start();
        BdfHtmlUtils.printSubsetHeader(this, this.bdfParameters, this.corpus, "corpus-advancedcommands");
        CorpusHtmlUtils.printCorpusToolbar(this, this.corpus, "corpus-advancedcommands", this.bdfServer);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("corpus").family("CRP").veil(true);
        this.printCorpusRemoveBox(commandBox);
        this.printCorpusAttributeChangeBox(commandBox);
        this.printDuplicationBox(commandBox);
        this.printReloadBox(commandBox);
        this.printCloneBox(commandBox);
        this.printConversionBox(commandBox);
        this.printReponderationBox(commandBox);
        this.printImageToIllustrationBox(commandBox);
        this.printSectionMergeBox(commandBox);
        this.end();
    }

    private boolean printCorpusRemoveBox(CommandBox commandBox) {
        if (!this.bdfParameters.isFichothequeAdmin()) {
            return false;
        }
        if (!this.corpus.isRemoveable()) {
            return false;
        }
        commandBox.errorPage("corpus-advancedcommands").page("_message");
        CorpusCommandBoxUtils.printCorpusRemoveBox(this, commandBox, this.corpus);
        return true;
    }

    private boolean printCorpusAttributeChangeBox(CommandBox commandBox) {
        commandBox.errorPage(null).page("corpus-advancedcommands");
        CorpusCommandBoxUtils.printCorpusAttributeChangeBox(this, commandBox, this.corpus);
        return true;
    }

    private boolean printDuplicationBox(CommandBox commandBox) {
        commandBox.errorPage("corpus-advancedcommands").page("duplicationlog");
        CorpusCommandBoxUtils.printDuplicationBox(this, commandBox, this.corpus, this.bdfServer, this.workingLang);
        return true;
    }

    private boolean printReloadBox(CommandBox commandBox) {
        commandBox.errorPage(null).page("corpus-advancedcommands");
        CorpusCommandBoxUtils.printReloadBox(this, commandBox, this.corpus);
        return true;
    }

    private boolean printCloneBox(CommandBox commandBox) {
        if (!this.bdfParameters.isFichothequeAdmin()) {
            return false;
        }
        commandBox.errorPage("corpus-advancedcommands").page("corpus-phrasesform");
        CorpusCommandBoxUtils.printCloneBox(this, commandBox, this.corpus, this.bdfServer, this.workingLang);
        return true;
    }

    private boolean printConversionBox(CommandBox commandBox) {
        commandBox.errorPage(null).page("corpus-advancedcommands");
        CorpusCommandBoxUtils.printConversionBox(this, commandBox, this.corpus, this.workingLang);
        return true;
    }

    private boolean printReponderationBox(CommandBox commandBox) {
        commandBox.errorPage("corpus-advancedcommands").page("reponderationlog");
        CorpusCommandBoxUtils.printReponderationBox(this, commandBox, this.corpus);
        return true;
    }

    private boolean printImageToIllustrationBox(CommandBox commandBox) {
        commandBox.errorPage(null).page("corpus-advancedcommands");
        CorpusCommandBoxUtils.printImageToIllustrationBox(this, commandBox, this.corpus, this.bdfServer, this.workingLang);
        return true;
    }

    private boolean printSectionMergeBox(CommandBox commandBox) {
        if (this.corpus.getCorpusMetadata().getSectionList().size() < 2) {
            return false;
        }
        commandBox.errorPage(null).page("corpus-advancedcommands");
        CorpusCommandBoxUtils.printSectionMergeBox(this, commandBox, this.corpus, this.workingLang);
        return true;
    }
}

