/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.addenda;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.DocumentJsLibs;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.tools.parsers.DocumentChangeInfo;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.text.FileName;

public class DocumentChangeHtmlProducer
extends BdfServerHtmlProducer {
    private static final String NOCHANGE_STATE = "nochange";
    private static final String UPDATE_STATE = "update";
    private static final String REMOVE_STATE = "remove";
    private static final String CREATE_STATE = "create";
    private final String appelant;
    private String originalName;
    private final String changeType;
    private String basename;
    private final List<VersionState> versionStateList = new ArrayList<VersionState>();
    private final Addenda addenda;
    private final String titleKey;
    private Document document;

    private DocumentChangeHtmlProducer(BdfParameters bdfParameters, String appelant, String changeType, Addenda addenda) {
        super(bdfParameters);
        this.addThemeCss("document.css");
        this.setBodyCssClass("global-body-ToolWindow");
        this.appelant = appelant;
        this.addJsLib(DocumentJsLibs.CHANGE);
        this.changeType = changeType;
        this.addenda = addenda;
        this.titleKey = changeType.equals("document") ? "_ title.addenda.documentchange" : (changeType.equals("creation") ? "_ title.addenda.documentcreate" : "");
    }

    public static DocumentChangeHtmlProducer newDocumentCreate(BdfParameters bdfParameters, String appelant, String originalName, DocumentChangeInfo documentChangeInfo, Addenda addenda) {
        DocumentChangeHtmlProducer htmlProducer = new DocumentChangeHtmlProducer(bdfParameters, appelant, "creation", addenda);
        htmlProducer.originalName = originalName;
        htmlProducer.basename = documentChangeInfo.getNewBasename();
        int tmpFileNameCount = documentChangeInfo.getTmpFileCount();
        for (int i = 0; i < tmpFileNameCount; ++i) {
            FileName tmpFileName = documentChangeInfo.getTmpFileName(i);
            VersionState versionState = new VersionState(tmpFileName.getExtension());
            versionState.state = CREATE_STATE;
            versionState.tmpFileName = tmpFileName;
            htmlProducer.versionStateList.add(versionState);
        }
        return htmlProducer;
    }

    public static DocumentChangeHtmlProducer newDocumentChange(BdfParameters bdfParameters, String appelant, Document document, DocumentChangeInfo documentChangeInfo, Addenda addenda) {
        VersionState versionState;
        String extension;
        DocumentChangeHtmlProducer htmlProducer = new DocumentChangeHtmlProducer(bdfParameters, appelant, "document", addenda);
        String currentBaseName = document.getBasename();
        String newBasename = documentChangeInfo.getNewBasename();
        htmlProducer.basename = newBasename != null ? newBasename : currentBaseName;
        htmlProducer.document = document;
        LinkedHashMap<String, FileName> changeMap = new LinkedHashMap<String, FileName>();
        int tmpFileNameCount = documentChangeInfo.getTmpFileCount();
        for (int i = 0; i < tmpFileNameCount; ++i) {
            FileName tmpFileName = documentChangeInfo.getTmpFileName(i);
            changeMap.put(tmpFileName.getExtension(), tmpFileName);
        }
        HashSet<String> removedSet = new HashSet<String>();
        int removedExtensionCount = documentChangeInfo.getRemovedExtensionCount();
        for (int i = 0; i < removedExtensionCount; ++i) {
            String string = documentChangeInfo.getRemovedExtension(i);
            removedSet.add(string);
            changeMap.remove(string);
        }
        for (Version version : document.getVersionList()) {
            extension = version.getExtension();
            versionState = new VersionState(extension);
            if (removedSet.contains(extension)) {
                versionState.state = REMOVE_STATE;
            } else if (changeMap.containsKey(extension)) {
                versionState.state = UPDATE_STATE;
                versionState.tmpFileName = (FileName)changeMap.get(extension);
            } else {
                versionState.state = NOCHANGE_STATE;
            }
            versionState.currentFileName = currentBaseName + "." + extension;
            htmlProducer.versionStateList.add(versionState);
            changeMap.remove(extension);
        }
        for (Map.Entry entry : changeMap.entrySet()) {
            extension = (String)entry.getKey();
            versionState = new VersionState(extension);
            versionState.state = CREATE_STATE;
            versionState.tmpFileName = (FileName)entry.getValue();
            htmlProducer.versionStateList.add(versionState);
        }
        return htmlProducer;
    }

    @Override
    public void printHtml() {
        String clientId = this.generateId();
        JsObject args = JsObject.init().put("clientId", clientId).put("changeType", this.changeType).put("appelant", this.appelant).put("addenda", this.addenda.getSubsetName()).put("newName", this.basename).put("originalName", this.originalName).put("namingInfo", FichothequeUtils.getPhraseLabel(this.addenda.getMetadata().getPhrases(), "naming", this.workingLang));
        if (this.document != null) {
            args.put("documentId", this.document.getId()).put("documentName", this.document.getBasename());
        }
        ArrayList<JsObject> extensionList = new ArrayList<JsObject>();
        for (VersionState versionState : this.versionStateList) {
            String currentFileName;
            String extension = versionState.getExtension();
            JsObject extensionObject = JsObject.init().put("extension", extension).put("state", versionState.getState());
            FileName tmpFileName = versionState.getTmpFileName();
            if (tmpFileName != null) {
                extensionObject.put("tmpFileName", tmpFileName.toString()).put("tmpUrl", ConfigurationUtils.getTmpRelativeUrl(tmpFileName.toString()));
            }
            if ((currentFileName = versionState.getCurrentFileName()) != null) {
                extensionObject.put("currentFileName", currentFileName);
            }
            extensionList.add(extensionObject);
        }
        args.put("extensionArray", extensionList);
        this.startLoc(this.titleKey);
        this.SCRIPT().__jsObject("AddendaDoc.Change.ARGS", args)._SCRIPT();
        this.DIV(HA.id(clientId).classes("document-Client"))._DIV();
        this.end();
    }

    private static class VersionState {
        private final String extension;
        private String state;
        private FileName tmpFileName;
        private String currentFileName;

        private VersionState(String extension) {
            this.extension = extension;
        }

        private String getExtension() {
            return this.extension;
        }

        private String getState() {
            return this.state;
        }

        private FileName getTmpFileName() {
            return this.tmpFileName;
        }

        private String getCurrentFileName() {
            return this.currentFileName;
        }
    }
}

