/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.forms;

import fr.exemole.bdfserver.api.ficheform.FormElement;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.namespaces.FicheFormSpace;
import fr.exemole.bdfserver.html.forms.CorpusFieldFormHtml;
import fr.exemole.bdfserver.html.forms.FormParameters;
import fr.exemole.bdfserver.html.forms.IncludeFormHtml;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.UserLangContext;

public class FormHandler {
    private final FormParameters formParameters;

    public FormHandler(FormParameters formParameters) {
        this.formParameters = formParameters;
    }

    public FormParameters getFormParameters() {
        return this.formParameters;
    }

    public Lang getWorkingLang() {
        return this.formParameters.workingLang();
    }

    public UserLangContext getUserLangContext() {
        return this.formParameters.userLangContext();
    }

    public String getPrefixedName(String name) {
        String namePrefix = this.formParameters.namePrefix();
        if (!namePrefix.isEmpty()) {
            name = namePrefix + "_" + name;
        }
        return name;
    }

    public String getPrefixedName(FormElement formElement) {
        return this.getPrefixedName(this.getName(formElement));
    }

    public String getPrefixedName(FormElement.Field fieldElement) {
        CorpusField corpusField = fieldElement.getCorpusField();
        return this.getPrefixedName(corpusField.getFieldString());
    }

    public String getPrefixedName(FormElement.Include includeElement) {
        return this.getPrefixedName(includeElement.getIncludeName());
    }

    public String getPrefixedName(FieldKey fieldKey, String subtype) {
        SubfieldKey subfieldKey = SubfieldKey.toSubfieldKey(fieldKey, subtype);
        return this.getPrefixedName(subfieldKey.getKeyString());
    }

    public String getGoto(FormElement formElement) {
        String name = this.getName(formElement);
        String logoPrefix = this.formParameters.gotoPrefix();
        if (!logoPrefix.isEmpty()) {
            name = logoPrefix + "/" + name;
        }
        return name;
    }

    public HtmlAttributes getEntryAttributes(String otherName, FormElement formElement) {
        return this.getEntryAttributes(otherName.replace(':', '_'), formElement.isMandatory(), null, "ficheform-standard-Entry", formElement.getAttributes(), null);
    }

    public HtmlAttributes getEntryAttributes(FormElement formElement) {
        return this.getEntryAttributes(formElement, null, "ficheform-standard-Entry");
    }

    public HtmlAttributes getEntryAttributes(FormElement formElement, String entryType) {
        return this.getEntryAttributes(formElement, entryType, "ficheform-standard-Entry");
    }

    public HtmlAttributes getEntryAttributes(FormElement formElement, String entryType, String classes) {
        return this.getEntryAttributes(this.getPrefixedName(formElement).replace(':', '_'), formElement.isMandatory(), entryType, classes, formElement.getAttributes(), this.getGoto(formElement));
    }

    public HtmlAttributes getEntryAttributes(String key, boolean isMandatory, String entryType, String classes, Attributes attributes, String gotoString) {
        HtmlAttributes htmlAttributes = HA.attr("data-ficheform-role", "entry").attr("data-ficheform-key", key).attr(isMandatory, "data-ficheform-mandatory", "1").attr("data-ficheform-entry", entryType).attr("data-goto", gotoString).classes(classes);
        Attribute attribute = attributes.getAttribute(FicheFormSpace.CLASSES_KEY);
        if (attribute != null) {
            for (String value : attribute) {
                htmlAttributes.addClass(value);
            }
        }
        return htmlAttributes;
    }

    public boolean printFormElement(HtmlPrinter hp, FormElement formElement) {
        if (formElement instanceof FormElement.Field) {
            return CorpusFieldFormHtml.print(hp, (FormElement.Field)formElement, this);
        }
        if (formElement instanceof FormElement.Include) {
            return IncludeFormHtml.print(hp, (FormElement.Include)formElement, this);
        }
        return false;
    }

    private String getName(FormElement formElement) {
        if (formElement instanceof FormElement.Field) {
            return ((FormElement.Field)formElement).getCorpusField().getFieldString();
        }
        if (formElement instanceof FormElement.Include) {
            return ((FormElement.Include)formElement).getIncludeName();
        }
        return "";
    }

    public static FormHandler init(FormParameters formParameters) {
        return new FormHandler(formParameters);
    }

    public static FormHandler build(BdfParameters bdfParameters) {
        return new FormHandler(FormParameters.init(bdfParameters));
    }
}

