/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.AppInit;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.tools.apps.AppConf;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.html.TrustedHtml;
import net.mapeadores.util.html.jsoup.HtmlCleaners;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.text.RelativePath;

public class AppHtmlProducer
extends BdfServerHtmlProducer {
    private final AppConf appConf;

    public AppHtmlProducer(BdfServer bdfServer, LangPreference langPreference, AppConf appConf) {
        super(bdfServer, langPreference);
        this.appConf = appConf;
        this.init();
    }

    public AppHtmlProducer(BdfParameters bdfParameters, AppConf appConf) {
        super(bdfParameters);
        this.appConf = appConf;
        this.init();
    }

    private void init() {
        this.scanIcons();
        AppInit.init(this, this.appConf, this.bdfServer.getResourceStorages(), this.bdfServer.getExtensionManager());
    }

    @Override
    public void printHtml() {
        JsObject jsObject;
        this.startPhrase(this.appConf.getString("core_titlephrasename"));
        RelativePath appHtmlPath = StorageUtils.buildAppResourcePath(this.appConf.getAppName(), "app.html");
        DocStream docStream = this.bdfServer.getResourceStorages().getResourceDocStream(appHtmlPath);
        if (docStream != null) {
            String appHtml = docStream.getContent();
            TrustedHtml trustedHtml = HtmlCleaners.WELLFORMED.cleanHtml(appHtml);
            this.__append(trustedHtml);
        }
        if ((jsObject = this.appConf.getArgsJsObject()) != null) {
            this.SCRIPT().__jsObject("ARGS", jsObject)._SCRIPT();
        }
        this.end();
    }
}

