/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerConstants;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RedacteurCustomizeUICommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurCustomizeUI";
    public static final String COMMANDKEY = "_ USR-06";
    public static final String NOTAB_PARAMNAME = "notab";
    public static final String HIDEEMPTY_PARAMNAME = "hideempty";
    public static final String SYNTAXACTIVE_PARAMNAME = "syntaxactive";
    public static final String DATEINPUTS_PARAMNAME = "dateinputs";
    private BdfUserPrefs redacBdfUserPrefs;
    private boolean noTab;
    private boolean hideEmpty;
    private boolean syntaxActive;
    private String dateInputsType;

    public RedacteurCustomizeUICommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            session.getBdfServerEditor().getBdfUserPrefsEditor(this.redacBdfUserPrefs).setBoolean(BdfUserSpace.NOTAB_KEY, this.noTab).setBoolean(BdfUserSpace.HIDEEMPTY_KEY, this.hideEmpty).setBoolean(BdfUserSpace.SYNTAXACTIVE_KEY, this.syntaxActive).setDateInputsType(this.dateInputsType);
        }
        this.setDone("_ done.sphere.redacteurcustomizeui", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        Redacteur redacteur = this.requestHandler.getMandatoryRedacteur();
        boolean isSame = BdfUserUtils.isSame(this.bdfUser, redacteur);
        if (!isSame) {
            this.checkSubsetAdmin(redacteur.getSphere());
        }
        this.redacBdfUserPrefs = isSame ? this.bdfUser.getPrefs() : this.bdfServer.createBdfUser(redacteur).getPrefs();
        this.noTab = this.requestHandler.isTrue(NOTAB_PARAMNAME);
        this.hideEmpty = this.requestHandler.isTrue(HIDEEMPTY_PARAMNAME);
        this.syntaxActive = this.requestHandler.isTrue(SYNTAXACTIVE_PARAMNAME);
        String dit = this.requestHandler.getMandatoryParameter(DATEINPUTS_PARAMNAME);
        try {
            this.dateInputsType = BdfServerConstants.checkDateInputsType(dit);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(DATEINPUTS_PARAMNAME, dit);
        }
    }
}

