/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.tools.selection.SelectionOptionsBuilder;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.misc.DefBuilder;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.RelativePath;

public abstract class AbstractDefChangeCommand
extends AbstractBdfCommand {
    public static final String TARGETNAME_PARAMNAME = "targetname";
    public static final String TARGETPATH_PARAMNAME = "targetpath";
    public static final String SELECTIONDEFNAME_PARAMNAME = "selectiondefname";
    public static final String QUERY_XML_PARAMNAME = "query_xml";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";

    public AbstractDefChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    public void checkSelectionOptions(SelectionOptionsBuilder selectionOptionsBuilder) throws ErrorMessageException {
        String selectionDefName = this.requestHandler.getTrimedParameter(SELECTIONDEFNAME_PARAMNAME);
        selectionOptionsBuilder.setSelectionDefName(selectionDefName);
        BdfCommandUtils.parseQueries(this.fichotheque, this.requestHandler.getTrimedParameter(QUERY_XML_PARAMNAME), selectionOptionsBuilder.getCustomFichothequeQueriesBuilder());
    }

    public void checkDefBuilder(DefBuilder defBuilder) throws ErrorMessageException {
        LabelChange labelChange = this.requestHandler.getLabelChange(TITLE_PARAMPREFIX);
        for (Label label : labelChange.getChangedLabels()) {
            defBuilder.putLabel(label);
        }
        String attributes = this.requestHandler.getTrimedParameter(ATTRIBUTES_PARAMNAME);
        if (!attributes.isEmpty()) {
            defBuilder.getAttributesBuilder().changeAttributes(AttributeParser.parse(attributes));
        }
    }

    public String getTargetName() throws ErrorMessageException {
        return this.requestHandler.getTrimedParameter(TARGETNAME_PARAMNAME);
    }

    public RelativePath getTargetPath() throws ErrorMessageException {
        String targetPathString = this.requestHandler.getTrimedParameter(TARGETPATH_PARAMNAME);
        if (targetPathString.isEmpty()) {
            return RelativePath.EMPTY;
        }
        try {
            return RelativePath.parse(targetPathString);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.relativepath", targetPathString);
        }
    }
}

