/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.commands.AbstractPhrasesCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.overview.OverviewEngine;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.logging.CommandMessageBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LineLogsBuilder;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.request.RequestMap;

public class ConfChangeCommand
extends AbstractPhrasesCommand {
    public static final String COMMANDNAME = "ConfChange";
    public static final String COMMANDKEY = "_ CRP-35";
    public static final String CONF_PARAM = "conf";
    private Corpus corpus;
    private String conf;
    private OverviewEngine overviewEngine;

    public ConfChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = this.overviewEngine.run(session);
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.confchange", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.conf = this.getMandatory(CONF_PARAM);
        LineLogsBuilder lineLogsBuilder = new LineLogsBuilder();
        this.overviewEngine = new OverviewEngine(this.bdfServer, this.corpus, lineLogsBuilder);
        this.overviewEngine.parse(this.conf);
        if (lineLogsBuilder.hasMessage()) {
            CommandMessageBuilder commandMessageBuilder = CommandMessageBuilder.init();
            for (LineMessage lineMessage : lineLogsBuilder.toLineMessageList()) {
                commandMessageBuilder.addMultiError(lineMessage);
            }
            throw BdfErrors.error(commandMessageBuilder, "_ error.list.configuration");
        }
    }
}

