/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public abstract class AbstractCorpusCreationCommand
extends AbstractBdfCommand {
    public static final String CORPUSTYPE_PARAMNAME = "corpustype";
    public static final String STANDARD_PARAMVALUE = "standard";
    public static final String CORPUSSATELLITE_PARAMVALUE = "corpussatellite";
    public static final String THESAURUSSATELLITE_PARAMVALUE = "thesaurussatellite";
    public static final String MASTERTHESAURUS_PARAMNAME = "masterthesaurus";
    public static final String MASTERCORPUS_PARAMNAME = "mastercorpus";
    protected Subset masterSubset;

    public AbstractCorpusCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    protected void initSubsetMaster() throws ErrorMessageException {
        String corpusType = this.getMandatory(CORPUSTYPE_PARAMNAME);
        if (corpusType.equals(STANDARD_PARAMVALUE)) {
            this.masterSubset = null;
        } else if (corpusType.equals(THESAURUSSATELLITE_PARAMVALUE)) {
            String masterthesaurusId = this.getMandatory(MASTERTHESAURUS_PARAMNAME);
            this.masterSubset = FichothequeUtils.getThesaurus(this.bdfServer.getFichotheque(), masterthesaurusId);
            if (this.masterSubset == null) {
                throw BdfErrors.unknownParameterValue(MASTERTHESAURUS_PARAMNAME, masterthesaurusId);
            }
        } else if (corpusType.equals(CORPUSSATELLITE_PARAMVALUE)) {
            String mastercorpusId = this.getMandatory(MASTERCORPUS_PARAMNAME);
            this.masterSubset = FichothequeUtils.getCorpus(this.bdfServer.getFichotheque(), mastercorpusId);
            if (this.masterSubset == null) {
                throw BdfErrors.unknownParameterValue(MASTERCORPUS_PARAMNAME, mastercorpusId);
            }
            if (((Corpus)this.masterSubset).getMasterSubset() != null) {
                throw BdfErrors.unsupportedParameterValue(MASTERCORPUS_PARAMNAME, mastercorpusId);
            }
        } else {
            throw BdfErrors.unknownParameterValue(CORPUSTYPE_PARAMNAME, corpusType);
        }
    }
}

