/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.commands.AbstractPhrasesCommand;
import net.fichotheque.album.Album;
import net.fichotheque.album.metadata.AlbumMetadataEditor;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AlbumPhrasesCommand
extends AbstractPhrasesCommand {
    public static final String COMMANDNAME = "AlbumIntitule";
    public static final String COMMANDKEY = "_ ALB-02";
    private Album album;

    public AlbumPhrasesCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done = false;
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            AlbumMetadataEditor albumMetadataEditor = session.getFichothequeEditor().getAlbumEditor(this.album).getAlbumMetadataEditor();
            if (this.update(albumMetadataEditor)) {
                done = true;
            }
        }
        this.putResultObject("obj.album", this.album);
        if (done) {
            this.setDone("_ done.album.albumphrases", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.album = this.requestHandler.getMandatoryAlbum();
        this.checkSubsetAdmin(this.album);
        this.checkPhrasesParameters();
    }
}

