/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.album.Album;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.album.metadata.AlbumMetadataEditor;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AlbumDimChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AlbumDimChange";
    public static final String COMMANDKEY = "_ ALB-04";
    public static final String ALBUMDIM_WIDTH_PARAMNAME = "albumdimwidth";
    public static final String ALBUMDIM_HEIGHT_PARAMNAME = "albumdimheight";
    private AlbumDim albumDim;
    private int width = 0;
    private int height = 0;

    public AlbumDimChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Album album = this.albumDim.getAlbumMetadata().getAlbum();
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            AlbumMetadataEditor albumMetadataEditor = session.getFichothequeEditor().getAlbumEditor(album).getAlbumMetadataEditor();
            albumMetadataEditor.setDim(this.albumDim, this.width, this.height);
        }
        this.putResultObject("obj.album", album);
        this.putResultObject("obj.albumdim", this.albumDim);
        this.setDone("_ done.album.albumdimchange", this.albumDim.getName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.albumDim = this.requestHandler.getMandatoryAlbumDim();
        this.checkSubsetAdmin(this.albumDim.getAlbumMetadata().getAlbum());
        String dimType = this.albumDim.getDimType();
        if (AlbumUtils.needWidth(dimType)) {
            String widthString = this.getMandatory(ALBUMDIM_WIDTH_PARAMNAME).trim();
            if (widthString.isEmpty()) {
                throw BdfErrors.error("_ error.empty.width");
            }
            try {
                this.width = Integer.parseInt(widthString);
                if (this.width < 1) {
                    throw BdfErrors.error("_ error.wrong.width", widthString);
                }
            }
            catch (NumberFormatException nfe) {
                throw BdfErrors.error("_ error.wrong.width", widthString);
            }
        }
        if (AlbumUtils.needHeight(dimType)) {
            String heightString = this.getMandatory(ALBUMDIM_HEIGHT_PARAMNAME).trim();
            if (heightString.isEmpty()) {
                throw BdfErrors.error("_ error.empty.height");
            }
            try {
                this.height = Integer.parseInt(heightString);
                if (this.height < 1) {
                    throw BdfErrors.error("_ error.wrong.height", heightString);
                }
            }
            catch (NumberFormatException nfe) {
                throw BdfErrors.error("_ error.wrong.height", heightString);
            }
        }
    }
}

