/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.api.namespaces;

import net.fichotheque.Subset;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedNameSpace;

public final class BdfUserSpace {
    public static final CheckedNameSpace BDFUSER_NAMESPACE = CheckedNameSpace.build("bdfuser");
    public static final CheckedNameSpace DEFAULT_NAMESPACE = CheckedNameSpace.build("bdfuser.default");
    public static final CheckedNameSpace TABLE_NAMESPACE = CheckedNameSpace.build("bdfuser.table");
    public static final CheckedNameSpace THESAURUS_FILTER_NAMESPACE = CheckedNameSpace.build("bdfuser.thesaurus.filter");
    public static final CheckedNameSpace TEMPLATE_SIMPLE_NAMESPACE = CheckedNameSpace.build("bdfuser.template.simple");
    public static final CheckedNameSpace TEMPLATE_STREAM_NAMESPACE = CheckedNameSpace.build("bdfuser.template.stream");
    public static final CheckedNameSpace SPELLCHECK_NAMESPACE = CheckedNameSpace.build("bdfuser.spellcheck");
    public static final CheckedNameSpace SYNTAX_NAMESPACE = CheckedNameSpace.build("bdfuser.syntax");
    public static final AttributeKey TABLEEXPORT_WITH_KEY = AttributeKey.build(DEFAULT_NAMESPACE, "tableexport.with");
    public static final AttributeKey TABLEEXPORT_HEADERTYPE_KEY = AttributeKey.build(DEFAULT_NAMESPACE, "tableexport.headertype");
    public static final AttributeKey TABLEEXPORT_PATTERNMODE_KEY = AttributeKey.build(DEFAULT_NAMESPACE, "tableexport.patternmode");
    public static final AttributeKey TABLEEXPORT_STATUSSHEET_KEY = AttributeKey.build(DEFAULT_NAMESPACE, "tableexport.statussheet");
    public static final AttributeKey FICHEFORM_KEY = AttributeKey.build(BDFUSER_NAMESPACE, "ficheform");
    public static final AttributeKey INCLUDESCRIPTS_KEY = AttributeKey.build(BDFUSER_NAMESPACE, "includescripts");
    public static final AttributeKey NOTAB_KEY = AttributeKey.build(BDFUSER_NAMESPACE, "notab");
    public static final AttributeKey HIDEEMPTY_KEY = AttributeKey.build(BDFUSER_NAMESPACE, "hideempty");
    public static final AttributeKey SYNTAXACTIVE_KEY = AttributeKey.build(BDFUSER_NAMESPACE, "syntaxactive");
    public static final AttributeKey ADMIN_KEY = AttributeKey.build(BDFUSER_NAMESPACE, "admin");
    public static final AttributeKey DATEINPUTS_KEY = AttributeKey.build(BDFUSER_NAMESPACE, "dateinputs");

    private BdfUserSpace() {
    }

    public static AttributeKey toSimpleTemplateAttributeKey(TransformationKey transformationKey) {
        return AttributeKey.build(TEMPLATE_SIMPLE_NAMESPACE, transformationKey.getKeyString());
    }

    public static AttributeKey toStreamTemplateAttributeKey(TransformationKey transformationKey, String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("extension is null");
        }
        return AttributeKey.build(TEMPLATE_STREAM_NAMESPACE, transformationKey.getKeyString() + '.' + extension);
    }

    public static AttributeKey toTableAttributeKey(Subset subset) {
        return AttributeKey.build(TABLE_NAMESPACE, subset.getSubsetKeyString());
    }

    public static AttributeKey toFilterParametersKey(Thesaurus thesaurus) {
        return AttributeKey.build(THESAURUS_FILTER_NAMESPACE, thesaurus.getSubsetKeyString());
    }

    public static AttributeKey toSpellcheckAttributeKey(Subset subset) {
        return AttributeKey.build(SPELLCHECK_NAMESPACE, subset.getSubsetKeyString());
    }

    public static AttributeKey toSyntaxAttributeKey(Subset subset) {
        return AttributeKey.build(SYNTAX_NAMESPACE, subset.getSubsetKeyString());
    }
}

