/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.utils.instructions;

import fr.exemole.bdfext.utils.instructions.UtilsInstruction;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.DirectoryFichotheque;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.ParagraphBlock;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.primitives.FuzzyDate;

public class InsertionFiches
extends UtilsInstruction {
    private final SubsetKey dphCorpusKey = SubsetKey.build((String)"corpus_dph");
    private final SubsetKey etudedecasCorpusKey = SubsetKey.build((String)"corpus_etudedecas");
    private final Map<Integer, Correspondance> origineMap = new TreeMap<Integer, Correspondance>();
    private static final FieldKey dphComment = FieldKey.build((String)"section_commentaire");
    private static final FieldKey essComment = FieldKey.build((String)"section_commentaires");
    private static final FieldKey dphSources = FieldKey.build((String)"section_references");
    private static final FieldKey essSources = FieldKey.build((String)"section_sources");
    private static final FieldKey notes = FieldKey.build((String)"section_notes");
    private final FuzzyDate currentDate = FuzzyDate.current();
    private static final PersonItem redacteur = new PersonItem("admin/2");
    private static final FieldKey propOrigine = FieldKey.build((String)"prop_origine");

    @Override
    public Object runInstruction() {
        StringBuilder buf = new StringBuilder();
        try (EditSession editSession = this.bdfServer.initEditSession(this.bdfUser, "ext:Utils/InsertionFiches");){
            FichothequeEditor editor = editSession.getFichothequeEditor();
            CorpusEditor corpusEditor = editor.getCorpusEditor(this.etudedecasCorpusKey);
            String fichothequeDirString = this.requestMap.getParameter("fichotheque");
            File fichothequeDir = new File(fichothequeDirString);
            BdfdataDirectory bdfdataDirectory = new BdfdataDirectory(fichothequeDir, new File(fichothequeDir, "cache"), new File(fichothequeDir, "backup/bdfdata"));
            Fichotheque fichotheque2 = DirectoryFichotheque.buildReadOnly((BdfdataDirectory)bdfdataDirectory, (HtmlCleaner)this.bdfParameters.getBdfServer().getHtmlCleaner(), (MultiMessageHandler)LogUtils.NULL_MULTIMESSAGEHANDLER, null);
            Corpus corpus = (Corpus)fichotheque2.getSubset(this.dphCorpusKey);
            for (FicheMeta origine : corpus.getFicheMetaList()) {
                Fiche fiche = corpus.getFiche(origine);
                Correspondance correspondance = new Correspondance(origine, fiche);
                this.origineMap.put(origine.getId(), correspondance);
            }
            for (Correspondance correspondance : this.origineMap.values()) {
                correspondance.create(corpusEditor);
            }
            for (Correspondance correspondance : this.origineMap.values()) {
                correspondance.save(corpusEditor);
            }
        }
        return buf.toString();
    }

    private class Correspondance {
        private final FicheMeta origine;
        private FicheMeta destination;
        private final Fiche fiche;

        private Correspondance(FicheMeta origine, Fiche fiche) {
            this.origine = origine;
            this.fiche = fiche;
        }

        private void create(CorpusEditor corpusEditor) {
            try {
                this.destination = corpusEditor.createFiche(-1);
                corpusEditor.setDate(this.destination, InsertionFiches.this.currentDate, false);
            }
            catch (ExistingIdException existingIdException) {
            }
            catch (NoMasterIdException noMasterIdException) {
                // empty catch block
            }
        }

        private void save(CorpusEditor corpusEditor) {
            this.convertSection(dphComment, essComment);
            this.convertSection(dphSources, essSources);
            Section section = this.fiche.getSection(notes);
            if (section != null) {
                int ficheBlockCount = section.size();
                for (int i = 0; i < ficheBlockCount; ++i) {
                    FicheBlock ficheBlock = (FicheBlock)section.get(i);
                    if (!(ficheBlock instanceof ParagraphBlock)) continue;
                    ParagraphBlock p = (ParagraphBlock)ficheBlock;
                    int textContentCount = p.size();
                    for (int j = 0; j < textContentCount; ++j) {
                        S span;
                        short type;
                        Object obj = p.get(j);
                        if (!(obj instanceof S) || (type = (span = (S)obj).getType()) != 8) continue;
                        String ref = span.getRef();
                        if (ref.startsWith("dph/")) {
                            ref = ref.substring(4);
                        }
                        try {
                            int id = Integer.parseInt(ref);
                            Correspondance correspondance = (Correspondance)InsertionFiches.this.origineMap.get(id);
                            if (correspondance == null) continue;
                            int nvid = correspondance.destination.getId();
                            span.setRef(String.valueOf(nvid));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.fiche.setOwners(FicheUtils.toFicheItems((FicheItem)redacteur));
            this.fiche.setProp(propOrigine, (FicheItem)new Item("dph/" + this.origine.getId()));
            corpusEditor.saveFiche(this.destination, (FicheAPI)this.fiche);
        }

        private void convertSection(FieldKey fk1, FieldKey fk2) {
            Section section = this.fiche.getSection(fk1);
            this.fiche.setSection(fk2, (FicheBlocks)section);
            this.fiche.setSection(fk1, null);
        }
    }
}

