/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.utils.migration;

import fr.exemole.bdfext.utils.migration.MigrationParameters;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.DirectoryFichotheque;
import java.io.File;
import java.util.List;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.addenda.Document;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.primitives.FuzzyDate;

public class MigrationEngine {
    private final MigrationParameters migrationParameters;
    private final FuzzyDate currentDate = FuzzyDate.current();

    public MigrationEngine(MigrationParameters migrationParameters) {
        this.migrationParameters = migrationParameters;
    }

    public void run(BdfUser bdfUser) {
        EditOrigin editOrigin = bdfUser.newEditOrigin("ext:Utils/MigrationEngine");
        try (EditSession editSession = this.migrationParameters.getDestinationBdfServer().initEditSession(editOrigin);){
            FichothequeEditor destinationFichothequeEditor = editSession.getFichothequeEditor();
            CorpusEditor destinationCorpusEditor = destinationFichothequeEditor.getCorpusEditor(this.migrationParameters.getDestinationSubsetKey());
            CroisementEditor destinationCroisementEditor = destinationFichothequeEditor.getCroisementEditor();
            File origineFichothequeDir = this.migrationParameters.getOrigineFichothequeDir();
            BdfdataDirectory bdfdataDirectory = new BdfdataDirectory(origineFichothequeDir, new File(origineFichothequeDir, "cache"), new File(origineFichothequeDir, "backup/bdfdata"));
            Fichotheque origineFichotheque = DirectoryFichotheque.buildReadOnly((BdfdataDirectory)bdfdataDirectory, (HtmlCleaner)this.migrationParameters.getDestinationBdfServer().getHtmlCleaner(), (MultiMessageHandler)LogUtils.NULL_MULTIMESSAGEHANDLER, null);
            Corpus origineCorpus = (Corpus)origineFichotheque.getSubset(this.migrationParameters.getOrigineSubsetKey());
            TreeMap<Integer, Correspondance> origineCorrespondanceMap = new TreeMap<Integer, Correspondance>();
            TreeMap documentCorrespondanceMap = new TreeMap();
            for (FicheMeta origineFicheMeta : origineCorpus.getFicheMetaList()) {
                Correspondance correspondance = new Correspondance(origineFicheMeta);
                origineCorrespondanceMap.put(origineFicheMeta.getId(), correspondance);
            }
            for (Correspondance correspondance : origineCorrespondanceMap.values()) {
                correspondance.createDestination(destinationCorpusEditor);
            }
            for (Correspondance correspondance : origineCorrespondanceMap.values()) {
                FicheMeta origineFicheMeta = correspondance.getOrigineFicheMeta();
                Fiche origineFiche = origineCorpus.getFiche(origineFicheMeta);
                this.save(destinationCorpusEditor, correspondance.getDestinationFicheMeta(), origineFiche);
            }
        }
    }

    private void save(CorpusEditor corpusEditor, FicheMeta destinationFicheMeta, Fiche origineFiche) {
        origineFiche.setOwners(this.migrationParameters.getRedacteursList());
        List<FieldToFieldConverter> fieldToFieldConverterList = this.migrationParameters.getFieldToFieldConverterList();
        for (FieldToFieldConverter ficheConverter : fieldToFieldConverterList) {
            ficheConverter.convert(destinationFicheMeta, origineFiche, true);
        }
        corpusEditor.saveFiche(destinationFicheMeta, (FicheAPI)origineFiche);
    }

    private class Correspondance {
        private final FicheMeta origineFicheMeta;
        private FicheMeta destinationFicheMeta;

        private Correspondance(FicheMeta origineFicheMeta) {
            this.origineFicheMeta = origineFicheMeta;
        }

        private void createDestination(CorpusEditor corpusEditor) {
            try {
                this.destinationFicheMeta = corpusEditor.createFiche(-1);
                corpusEditor.setDate(this.destinationFicheMeta, MigrationEngine.this.currentDate, false);
            }
            catch (ExistingIdException | NoMasterIdException throwable) {
                // empty catch block
            }
        }

        public FicheMeta getOrigineFicheMeta() {
            return this.origineFicheMeta;
        }

        public FicheMeta getDestinationFicheMeta() {
            return this.destinationFicheMeta;
        }
    }

    private class DocumentCorrespondance {
        private final int origineSubsetId;
        private final Document destinationDocument;

        public DocumentCorrespondance(int origineSubsetId, Document destinationDocument) {
            this.origineSubsetId = origineSubsetId;
            this.destinationDocument = destinationDocument;
        }

        public int getOrigineSubsetId() {
            return this.origineSubsetId;
        }

        public Document getDestinationDocument() {
            return this.destinationDocument;
        }
    }
}

