/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.simplegrille.xml;

import java.text.ParseException;
import java.util.function.Consumer;
import net.desmodo.simplegrille.api.SimpleAtlasBuilder;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.InvalidXMLException;
import org.w3c.dom.Element;

public class SimpleAtlasDOMReader {
    private final SimpleAtlasBuilder simpleAtlasBuilder;

    public SimpleAtlasDOMReader(SimpleAtlasBuilder simpleAtlasBuilder) {
        this.simpleAtlasBuilder = simpleAtlasBuilder;
    }

    public void readDescripteurFilsList(Element element) {
        String autoIncrementString = element.getAttribute("auto-increment");
        if (autoIncrementString.length() > 0) {
            try {
                int autoIncrement = Integer.parseInt(autoIncrementString);
                this.simpleAtlasBuilder.setAutoIncrement(autoIncrement);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DOMUtils.readChildren((Element)element, (Consumer)new SimpleDescripteurFilsConsumer());
    }

    public void readAtlasLib(Element element) {
        Label libelle = this.readLib(element);
        if (libelle != null) {
            this.simpleAtlasBuilder.putAtlasLibelle(libelle);
        }
    }

    private Label readLib(Element element) {
        try {
            return LabelUtils.readLabel((Element)element);
        }
        catch (ParseException lie) {
            return null;
        }
    }

    private class SimpleDescripteurFilsConsumer
    implements Consumer<Element> {
        private SimpleDescripteurFilsConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("simple-descripteur-fils")) {
                String iddesc = element.getAttribute("iddesc");
                if (iddesc.length() == 0) {
                    throw new InvalidXMLException("missing iddesc attribute in simple-descripteur-fils");
                }
                String pereIddesc = element.getAttribute("pere-iddesc");
                if (iddesc.length() == 0) {
                    throw new InvalidXMLException("missing pere-iddesc attribute in simple-descripteur-fils");
                }
                String idctxt = element.getAttribute("idctxt");
                if (idctxt.length() == 0) {
                    throw new InvalidXMLException("missing idctxt attribute in simple-descripteur-fils");
                }
                int index = SimpleAtlasDOMReader.this.simpleAtlasBuilder.addSimpleDescripteurFils(iddesc, pereIddesc, idctxt);
                if (index != -1) {
                    DOMUtils.readChildren((Element)element, (Consumer)new LibConsumer(index));
                }
            }
        }
    }

    private class LibConsumer
    implements Consumer<Element> {
        private final int index;

        private LibConsumer(int index) {
            this.index = index;
        }

        @Override
        public void accept(Element element) {
            Label libelle;
            String tagName = element.getTagName();
            if (tagName.equals("lib") && (libelle = SimpleAtlasDOMReader.this.readLib(element)) != null) {
                SimpleAtlasDOMReader.this.simpleAtlasBuilder.putDescripteurFilsLibelle(this.index, libelle);
            }
        }
    }
}

