/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.simplegrille.export;

import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.desmodo.simplegrille.api.SimpleAtlas;
import net.desmodo.simplegrille.api.SimpleStructure;
import net.desmodo.simplegrille.smgrimpl.SimpleAtlasBuilderImpl;
import net.desmodo.simplegrille.smstimpl.SimpleStructureBuilderImpl;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;

public class SimpleGrilleExport {
    private final Fichotheque fichotheque;
    private FicheMeta ficheMeta;
    private final FicheAPI fiche;
    private Lang lang;
    private final SimpleStructureBuilderImpl structureBuilder = new SimpleStructureBuilderImpl();
    private Thesaurus lastThesaurus;
    private final Map<Integer, String> thesaurusNameMap = new HashMap<Integer, String>();
    private final SimpleAtlas simpleAtlas;

    private SimpleGrilleExport(FicheMeta ficheMeta) {
        this.fichotheque = ficheMeta.getFichotheque();
        this.fiche = ficheMeta.getFicheAPI(false);
        this.initLang();
        this.buildContext();
        this.structureBuilder.addSimpleFamille("peres", null);
        this.buildDescripteurPere();
        SimpleStructure simpleStructure = this.structureBuilder.toSimpleStructure();
        SimpleAtlasBuilderImpl atlasBuilder = new SimpleAtlasBuilderImpl(simpleStructure);
        atlasBuilder.setPrefixe("AAA");
        this.simpleAtlas = atlasBuilder.toSimpleAtlas();
    }

    public static SimpleAtlas export(FicheMeta ficheMeta) {
        SimpleGrilleExport export = new SimpleGrilleExport(ficheMeta);
        return export.simpleAtlas;
    }

    private void initLang() {
        FieldKey fieldKey = FieldKey.build((String)"prop_langue");
        Prop prop = this.fiche.getProp(fieldKey);
        if (prop == null) {
            throw new IllegalStateException("Langue non d\u00e9finie");
        }
        FicheItem ficheItem = prop.getFicheItem();
        if (!(ficheItem instanceof LanguageItem)) {
            throw new IllegalStateException("Langue incorrecte : " + ficheItem.toString());
        }
        this.lang = ((LanguageItem)ficheItem).getLang();
        this.structureBuilder.addLang(this.lang);
    }

    private void buildDescripteurPere() {
        for (int i = 1; i < 10; ++i) {
            String lib = this.getDescripteurLib(i);
            CleanedString cleanedString = CleanedString.newInstance((CharSequence)lib);
            if (cleanedString == null) {
                if (i == 1) {
                    throw new IllegalStateException("Le premier descripteur p\u00e8re doit \u00eatre d\u00e9fini ! ");
                }
                return;
            }
            String iddesc = "pere" + i;
            String idfamille = "peres";
            String thesaurusName = this.thesaurusNameMap.get(i);
            int index = this.structureBuilder.addSimpleDescripteurPere(iddesc, idfamille, thesaurusName);
            this.structureBuilder.putDescripteurPereLibelle(index, LabelUtils.toLabel((Lang)this.lang, (CleanedString)cleanedString));
        }
    }

    private void buildContext() {
        HashSet<SubsetKey> traiteSet = new HashSet<SubsetKey>();
        for (int i = 1; i < 10; ++i) {
            Thesaurus thesaurus = this.getThesaurus(i);
            SubsetKey subsetKey = thesaurus.getSubsetKey();
            this.thesaurusNameMap.put(i, subsetKey.getSubsetName());
            if (traiteSet.contains(subsetKey)) continue;
            this.buildContext(thesaurus);
            traiteSet.add(subsetKey);
        }
    }

    private void buildContext(Thesaurus thesaurus) {
        String name = thesaurus.getSubsetName();
        List list = thesaurus.getFirstLevelList();
        if (list.isEmpty()) {
            throw new IllegalStateException("Th\u00e9saurus vide " + thesaurus.getSubsetKeyString());
        }
        for (Motcle motcle : list) {
            int index = this.structureBuilder.addSimpleContexte(motcle.getIdalpha(), null, name);
            for (Label label : motcle.getLabels()) {
                this.structureBuilder.putContexteLibelle(index, label);
            }
        }
    }

    private Thesaurus getThesaurus(int i) {
        Prop prop = this.getProp("thesaurus", i);
        if (prop == null) {
            if (this.lastThesaurus == null) {
                throw new IllegalStateException("Un champ th\u00e9saurus doit \u00eatre rempli");
            }
            return this.lastThesaurus;
        }
        String thesaurusName = ((Item)prop.getFicheItem()).getValue();
        Thesaurus thesaurus = null;
        try {
            SubsetKey subsetKey = SubsetKey.parse((short)2, (String)thesaurusName);
            thesaurus = (Thesaurus)this.fichotheque.getSubset(subsetKey);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (thesaurus == null) {
            throw new IllegalStateException("Nom de th\u00e9saurus incorrect = " + thesaurusName + " dans " + prop.getFieldKey().getKeyString());
        }
        if (!thesaurus.isIdalphaType()) {
            throw new IllegalStateException("Le th\u00e9saurus doit avoir des identifiants alphanum\u00e9riques / " + thesaurusName + " dans " + prop.getFieldKey().getKeyString());
        }
        this.lastThesaurus = thesaurus;
        return thesaurus;
    }

    private Prop getProp(String prefix, int i) {
        FieldKey fieldKey = FieldKey.build((short)1, (String)(prefix + i));
        return this.fiche.getProp(fieldKey);
    }

    private String getDescripteurLib(int i) {
        Prop prop = this.getProp("pere", i);
        if (prop == null) {
            return null;
        }
        String lib = ((Item)prop.getFicheItem()).getValue();
        return lib;
    }
}

