/* global Currency,Intl */
/**
 * Objet global définissant l'espace de nom Ficheform
 * 
 * @namespace ScarabeApi
 */
var ScarabeApi = {};

ScarabeApi.initHelpers = function (defaultCurrency, locale) {
    var dateFormat = new Intl.DateTimeFormat(locale, {
        year: "numeric",
        month: "short",
        day: "numeric"
    });
    var formatters = {
        amount: function(value, currency) {
            return _formatValue(value, currency, false);
        },
        amount_opposite: function(value, currency) {
            return _formatValue(value, currency, true);
        },
        currency: function(amount) {
            return defaultCurrency;
        },
        value: function(amount) {
            return _getValue(amount, false);
        },
        value_opposite: function(amount) {
            return _getValue(amount, true);
        },
        date: function(value) {
            if (!value) {
                 return "";
            }
            let formatString = dateFormat.format(new Date(value));
            formatString = formatString.replaceAll(" ", "\u00A0");
            return formatString;
        }
    };
    $.views.helpers({
        scarabe_format: formatters.amount,
        scarabe_format_opposite: formatters.amount_opposite,
        scarabe_currency:  formatters.currency,
        scarabe_value: formatters.value,
        scarabe_value_opposite: formatters.value_opposite,
        scarabe_dateformat: formatters.date
    });
    return formatters;


    function _formatValue(value, currency, opposite) {
        if (!value) {
            if (value !== 0) {
                return "";
            }
        }
        if (!$.isNumeric(value)) {
            currency = defaultCurrency;
            value = value[currency];
            if (!value) {
                if (value !== 0) {
                    return "";
                }
            }
        } else if (!currency) {
            currency = defaultCurrency;
        }
        if (opposite) {
            value = -value;
        }
        return Currency.formatAmount(value, currency, locale);
    }
    
    function _getValue(amount, opposite) {
        var currency = defaultCurrency;
        var value = amount;
        if ((amount) && (!$.isNumeric(amount))) {
            value = amount[currency];
        }
        if (!value) {
            if (value !== 0) {
                return "";
            }
        }
        var decimalValue = value / (Currency.get(currency).subunitMultiplicator);
        if (opposite) {
            decimalValue = -decimalValue;
        }
        return decimalValue.toString();
    }
    
};

ScarabeApi.completeRecap = function (recap, options) {
    var completeFunction;
    if ((options) && (options.completeFunction)) {
            completeFunction = options.completeFunction;
    }
    _checkOperationArray(recap.operations);
    _checkSubArray(recap.subArray);
    return recap;


    function _checkSubArray(subArray) {
        if (!subArray) {
            return;
        }
        for(let sub of subArray) {
            _checkOperationArray(sub.operations);
            _checkSubArray(sub.subArray);
        }
    }

    function _checkOperationArray(operations) {
        if (!operations) {
            return;
        }
        var remove = false;
        for(var i = operations.length - 1; i >= 0; i--) {
            remove = false;
            var operation = operations[i];
            _checkBackground(operation);
            remove = _isHidden(operation);
            if (completeFunction) {
                completeFunction(operation);
            }
            if(remove) {
               operations.splice(i, 1);
            }
        }
    }
  
    function _checkBackground(operation) {
        if (operation.attributes.hasOwnProperty("scarabejs:background")) {
            operation.background = operation.attributes["scarabejs:background"][0];
        } else {
            operation.background = "transparent";
        }
    }
    
    function _isHidden(operation) {
        if (operation.attributes.hasOwnProperty("scarabejs:hidden")) {
            var hiddenValue = operation.attributes["scarabejs:hidden"][0];
            switch(hiddenValue) {
                case "true":
                case "1":
                    return true;
                default:
                    return false;
            }
        } else {
            return false;
        }
    }
    
};