/* global Fapi,ScarabeApi */

ScarabeApi.Ajax = {};

/*
 * Details requestParameters
options = {
    requestParameters: {
        subset: "", (mandatory)
        id: "",
        idalpha: "",
        recursive: 1/0,
        selection: 1/0,
        withcolumns: 1/0,
        conversion: Currency code,
        date: Date ranve,
        filter: "",
        include: "",
        exclude: "",
        include_idalpha: "",
        exclude_idalpha: ""
    }
}

 */

ScarabeApi.Ajax.DEFAULT_DETAILS = {
    cmd: "AnalytiqueDetail",
    withrecap: 1
};

ScarabeApi.Ajax.loadAnalytiqueDetails = function (fapi, options) {
    var endPoint = fapi.getActionEndPoint("ext-scarabe", "AnalytiqueDetails");
    var requestParameters = fapi.buildRequestParameters(endPoint, options, ScarabeApi.Ajax.DEFAULT_DETAILS);
    if (!requestParameters.subset) {
        Fapi.log("subset parameter is missing");
        return;
    }
    $.ajax({
        url: endPoint.url,
        method: "GET",
        dataType: "json",
        data: requestParameters,
        xhrFields: {
           withCredentials: true
        },
        success: function (data, textStatus) {
            if (options) {
                fapi.handleResponseData(data, !(options.ignoreLogError), options.callback);
            }
        }
    });    
};

ScarabeApi.Ajax.loadAnalytiqueItem = function (fapi, options) {
    var endPoint = fapi.getActionEndPoint("ext-scarabe", "AnalytiqueItem");
    var requestParameters = fapi.buildRequestParameters(endPoint, options, ScarabeApi.Ajax.DEFAULT_DETAILS);
    if (!requestParameters.subset) {
        Fapi.log("subset parameter is missing");
        return;
    }
    if ((!requestParameters.id) && (!requestParameters.idalpha)) {
        Fapi.log("id or idalpha parameter is missing");
        return;
    }
    $.ajax({
        url: endPoint.url,
        method: "GET",
        dataType: "json",
        data: requestParameters,
        xhrFields: {
           withCredentials: true
        },
        success: function (data, textStatus) {
            if (options) {
                fapi.handleResponseData(data, !(options.ignoreLogError), options.callback);
            }
        }
    });    
};

ScarabeApi.Ajax.loadAnalytiqueRecap = function (fapi, options) {
    var endPoint = fapi.getActionEndPoint("ext-scarabe", "AnalytiqueRecap");
    var requestParameters = fapi.buildRequestParameters(endPoint, options, {
        cmd: "AnalytiqueRecap"
    });
    $.ajax({
        url: endPoint.url,
        method: "GET",
        dataType: "json",
        data: requestParameters,
        xhrFields: {
           withCredentials: true
        },
        success: function (data, textStatus) {
            if (options) {
                fapi.handleResponseData(data, !(options.ignoreLogError), options.callback);
            }
        }
    });
};
