/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation.banque;

import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.BanqueRecap;
import fr.exemole.bdfext.scarabe.api.core.Banques;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import fr.exemole.bdfext.scarabe.tools.core.BanqueRecapBuilder;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import java.util.Map;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.ExtendedCurrency;

public class RecapitulatifTableEngine
extends TableEngine {
    private final Recapitulatif recapitulatif;
    private final OdTableDef odTableDef;
    private final String title;

    public RecapitulatifTableEngine(Recapitulatif recapitulatif, ScarabeLocalisation scarabeLocalisation) {
        super(scarabeLocalisation);
        this.recapitulatif = recapitulatif;
        this.odTableDef = OdTableDefBuilder.init((String)"").addStandard().addStandard().toOdTableDef();
        this.title = scarabeLocalisation.getMessageLocalisation().toNotNullString("_ title.scarabe.banques");
    }

    @Override
    public OdTableDef getOdTableDef() {
        return this.odTableDef;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void writeHead(ScarabeTableWriter tableWriter) {
    }

    @Override
    public void writeBody(ScarabeTableWriter tableWriter) {
        Lang workingLang = this.getScarabeLocalisation().getWorkingLang();
        Map<String, BanqueRecap> banqueRecapMap = BanqueRecapBuilder.fromRecapitulatif(this.recapitulatif);
        Banques banques = this.recapitulatif.getBanques();
        for (Banque banque : banques) {
            if (banque.hasError()) continue;
            ExtendedCurrency currency = banque.getCurrency();
            String idalpha = banque.getCodeBanque();
            BanqueRecap banqueRecap = banqueRecapMap.get(idalpha);
            tableWriter.startRow((short)105);
            tableWriter.addStringCell(banque.getTitle(workingLang), 2);
            tableWriter.endRow();
            long report = banque.getReportMoneyLong();
            this.printMontantRow(tableWriter, "_ label.scarabe.report", report, currency);
            if (banqueRecap == null) continue;
            this.printMontantRow(tableWriter, "_ label.scarabe.debit", banqueRecap.getDebitMoneyLong(), currency);
            this.printMontantRow(tableWriter, "_ label.scarabe.credit", banqueRecap.getCreditMoneyLong(), currency);
            this.printMontantRow(tableWriter, "_ label.scarabe.solde", banqueRecap.getSoldeMoneyLong(), currency);
        }
    }

    private void printMontantRow(ScarabeTableWriter tableWriter, String messageKey, long montant, ExtendedCurrency currency) {
        tableWriter.startRow();
        tableWriter.addMessageCell(messageKey, 1, true);
        tableWriter.addMoneyCell(montant, currency);
        tableWriter.endRow();
    }
}

