/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation;

import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import fr.exemole.bdfext.scarabe.tools.exportation.CategoryColumnDef;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.mapeadores.opendocument.io.odtable.OdColumnDef;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;

public class HtmlTableWriter
implements ScarabeTableWriter {
    private static final HtmlAttributes SOLDE_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneSolde");
    private static final HtmlAttributes TOTAUX_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneTotaux");
    private static final HtmlAttributes AVANCESOLDEE_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneAvanceSoldee");
    private static final HtmlAttributes AVENIR_TOTAUX_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneTotaux scarabe-detail-Avenir");
    private static final HtmlAttributes TITREINTERMEDIAIRE_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneTitreIntermediaire");
    private static final HtmlAttributes AVENIR_TITREINTERMEDIAIRE_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneTitreIntermediaire scarabe-detail-Avenir");
    private static final HtmlAttributes AVENIR_ROW_ATTR = HA.classes((String)"scarabe-detail-Avenir");
    private static final HtmlAttributes MONTANT_CELL_ATTR = HA.classes((String)"scarabe-detail-Montant");
    private static final HtmlAttributes MONTANTNEGATIF_CELL_ATTR = HA.classes((String)"scarabe-detail-Montant scarabe-detail-Negatif");
    private static final HtmlAttributes LAST_MONTANT_CELL_ATTR = HA.classes((String)"scarabe-detail-Montant scarabe-detail-Montant_end");
    private static final HtmlAttributes MIDDLE_MONTANT_CELL_ATTR = HA.classes((String)"scarabe-detail-Montant scarabe-detail-Montant_middle");
    private static final HtmlAttributes PIECE_CELL_ATTR = HA.classes((String)"scarabe-detail-Piece");
    private static final HtmlAttributes DATE_CELL_ATTR = HA.classes((String)"scarabe-detail-Date");
    private static final HtmlAttributes INTITULES_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneIntitules");
    private static final HtmlAttributes TITRE_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneTitre");
    private static final HtmlAttributes ID_CELL_ATTR = HA.classes((String)"scarabe-detail-Id");
    private static final HtmlAttributes EMPTY_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneVide");
    private static final HtmlAttributes DATESANTERIEURES_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneDatesAnterieures");
    private static final HtmlAttributes AVENIR_DATESANTERIEURES_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneDatesAnterieures scarabe-detail-Avenir");
    private static final HtmlAttributes AGREGAT_DETAIL_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneAgregatRecap");
    private static final HtmlAttributes SOLDE_DETAIL_ROW_ATTR = HA.classes((String)"scarabe-detail-LigneSoldeRecap");
    private final HtmlAttributes linkAttr = HA.href((CharSequence)"").target("_blank");
    private final HtmlPrinter hp;
    private final DecimalFormatSymbols symbols;
    private final OdTableDef odTableDef;
    private boolean onHead = false;
    private int columnNumber = 0;
    private int rowNumber;

    public HtmlTableWriter(HtmlPrinter hp, Locale formatLocale, OdTableDef odTableDef) {
        this.hp = hp;
        this.symbols = new DecimalFormatSymbols(formatLocale);
        this.odTableDef = odTableDef;
        this.rowNumber = 0;
    }

    public int startRow() {
        return this.startRow((short)100);
    }

    @Override
    public int startRow(short rowType) {
        ++this.rowNumber;
        this.hp.TR(HtmlTableWriter.getRowAttributes(rowType));
        this.columnNumber = 0;
        return this.rowNumber;
    }

    @Override
    public void addNullCell(int cellCount) {
        if (cellCount == 1) {
            ++this.columnNumber;
            HtmlAttributes attr = null;
            String category = this.getCurrentCategory();
            if (category != null) {
                if (category.equals("LAST_MONTANT")) {
                    attr = LAST_MONTANT_CELL_ATTR;
                } else if (category.equals("MIDDLE_MONTANT")) {
                    attr = MIDDLE_MONTANT_CELL_ATTR;
                }
            }
            this.hp.TD(attr)._TD();
        } else {
            for (int i = 0; i < cellCount; ++i) {
                this.hp.TD()._TD();
            }
            this.columnNumber += cellCount;
        }
    }

    @Override
    public int addMoneyCell(long moneyLong, ExtendedCurrency currency) {
        return this.addMoneyCell(new Amount(moneyLong, currency));
    }

    public int addMoneyCell(Amount amount) {
        ++this.columnNumber;
        if (amount == null) {
            this.hp.TD()._TD();
        } else {
            HtmlAttributes attr = MONTANT_CELL_ATTR;
            String category = this.getCurrentCategory();
            if (category != null) {
                if (category.equals("SOLDE")) {
                    if (amount.getMoneyLong() < 0L) {
                        attr = MONTANTNEGATIF_CELL_ATTR;
                    }
                } else if (category.equals("LAST_MONTANT")) {
                    attr = LAST_MONTANT_CELL_ATTR;
                } else if (category.equals("MIDDLE_MONTANT")) {
                    attr = MIDDLE_MONTANT_CELL_ATTR;
                }
            }
            this.hp.TD(attr).__escape((CharSequence)amount.toLitteralString(this.symbols, false))._TD();
        }
        return this.columnNumber;
    }

    @Override
    public int addMessageCell(String messageKey) {
        ++this.columnNumber;
        if (messageKey.equals("_ label.scarabe.rapprochement")) {
            messageKey = "_ label.scarabe.rapprochement_s";
        }
        this.startCell(null);
        this.hp.__localize(messageKey);
        this.endCell();
        return this.columnNumber;
    }

    @Override
    public void addMessageCell(String messageKey, int colspan, boolean withColon) {
        HtmlAttributes attributes = null;
        if (attributes == null) {
            attributes = HA.colspan((int)colspan);
        }
        this.startCell(attributes);
        this.hp.__localize(messageKey);
        if (withColon) {
            this.hp.__colon();
        }
        this.endCell();
        this.columnNumber += colspan;
    }

    public int addStringCell(String text) {
        ++this.columnNumber;
        if (text == null) {
            this.hp.TD()._TD();
        } else {
            this.startCell(null);
            this.hp.__escape((CharSequence)text);
            this.endCell();
        }
        return this.columnNumber;
    }

    @Override
    public void addStringCell(String text, int colspan) {
        this.addStringCell(text, colspan, false);
    }

    @Override
    public void addStringCell(String text, int colspan, boolean withColon) {
        HtmlAttributes attributes = null;
        if (attributes == null) {
            attributes = HA.colspan((int)colspan);
        }
        this.startCell(attributes);
        if (text != null) {
            this.hp.__escape((CharSequence)text);
            if (withColon) {
                this.hp.__colon();
            }
            this.endCell();
        }
        this.columnNumber += colspan;
    }

    @Override
    public int addHrefCell(String href, String text) {
        ++this.columnNumber;
        this.startCell(null);
        this.hp.A(this.linkAttr.href((CharSequence)href)).__escape((CharSequence)text)._A();
        this.endCell();
        return this.columnNumber;
    }

    @Override
    public int addHrefCell(String href, int integer) {
        ++this.columnNumber;
        String category = this.getCurrentCategory();
        HtmlAttributes attributes = null;
        if (category != null && category.equals("ID")) {
            attributes = ID_CELL_ATTR;
        }
        this.startCell(attributes);
        this.hp.A(this.linkAttr.href((CharSequence)href)).__append(integer)._A();
        this.endCell();
        return this.columnNumber;
    }

    public int addDateCell(FuzzyDate date) {
        ++this.columnNumber;
        if (date == null) {
            this.hp.TD()._TD();
        } else {
            this.startCell(DATE_CELL_ATTR);
            this.hp.__escape((CharSequence)date.toISOString());
            this.endCell();
        }
        return this.columnNumber;
    }

    public int addDecimalCell(Decimal decimal) {
        ++this.columnNumber;
        if (decimal == null) {
            this.hp.TD()._TD();
        } else {
            this.hp.TD().__escape((Object)decimal)._TD();
        }
        return this.columnNumber;
    }

    public int addIntegerCell(Long lg) {
        ++this.columnNumber;
        if (lg == null) {
            this.hp.TD()._TD();
        } else {
            String category = this.getCurrentCategory();
            HtmlAttributes attributes = null;
            if (category != null && category.equals("PIECE")) {
                attributes = PIECE_CELL_ATTR;
            }
            this.startCell(attributes);
            this.hp.__append(lg.longValue());
            this.endCell();
        }
        return this.columnNumber;
    }

    public int addPercentageCell(Decimal decimal) {
        ++this.columnNumber;
        if (decimal == null) {
            this.hp.TD()._TD();
        } else {
            this.hp.TD().__escape((Object)decimal)._TD();
        }
        return this.columnNumber;
    }

    public int endRow() {
        this.hp._TR();
        return this.rowNumber;
    }

    public void setOnHead(boolean onHead) {
        this.onHead = onHead;
    }

    private String getCurrentCategory() {
        OdColumnDef odColumnDef = (OdColumnDef)this.odTableDef.getOdColumnDefList().get(this.columnNumber - 1);
        if (odColumnDef instanceof CategoryColumnDef) {
            return ((CategoryColumnDef)odColumnDef).getCategory();
        }
        return null;
    }

    private void startCell(HtmlAttributes attributes) {
        if (this.onHead) {
            this.hp.TH(attributes);
        } else {
            this.hp.TD(attributes);
        }
    }

    private void endCell() {
        if (this.onHead) {
            this.hp._TH();
        } else {
            this.hp._TD();
        }
    }

    private static HtmlAttributes getRowAttributes(short type) {
        switch (type) {
            case 104: 
            case 115: {
                return TOTAUX_ROW_ATTR;
            }
            case 102: {
                return SOLDE_ROW_ATTR;
            }
            case 103: {
                return INTITULES_ROW_ATTR;
            }
            case 101: {
                return TITRE_ROW_ATTR;
            }
            case 105: {
                return TITREINTERMEDIAIRE_ROW_ATTR;
            }
            case 107: {
                return EMPTY_ROW_ATTR;
            }
            case 109: {
                return AVENIR_TOTAUX_ROW_ATTR;
            }
            case 108: {
                return AVENIR_TITREINTERMEDIAIRE_ROW_ATTR;
            }
            case 110: {
                return AVENIR_ROW_ATTR;
            }
            case 106: {
                return AVANCESOLDEE_ROW_ATTR;
            }
            case 111: {
                return DATESANTERIEURES_ROW_ATTR;
            }
            case 112: {
                return AVENIR_DATESANTERIEURES_ROW_ATTR;
            }
            case 113: {
                return AGREGAT_DETAIL_ROW_ATTR;
            }
            case 114: {
                return SOLDE_DETAIL_ROW_ATTR;
            }
        }
        return null;
    }
}

