/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.recap;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueParameters;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.CustomLigneDef;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyChronology;
import fr.exemole.bdfext.scarabe.api.analytique.Operation;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeOperand;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AgregatBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.MandatoryException;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.MoneyChronologyBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.OperationBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.primitives.FuzzyDate;

public class AnalytiqueRecapBuilder {
    private static final List<AnalytiqueRecap> EMPTY_LIST = Collections.emptyList();
    private final Object recapObject;
    private final AnalytiqueParameters analytiqueParameters;
    private final Currencies currencies;
    private final OperationBuilder[] operationBuilderArray;
    private final Map<String, OperationBuilder> operationBuilderMap = new HashMap<String, OperationBuilder>();
    private final MoneyChronologyBuilder ligneChronologyBuilder;
    private final MoneyChronologyBuilder depenseChronologyBuilder;
    private final MoneyChronologyBuilder apportChronologyBuilder;
    private final MoneyChronologyBuilder avanceChronologyBuilder;
    private final MoneyChronologyBuilder avenirChronologyBuilder;
    private final List<AnalytiqueRecap> childList = new ArrayList<AnalytiqueRecap>();
    private int apportIndex;
    private int depenseIndex;
    private int avanceIndex;
    private int avenirDepenseIndex;

    public AnalytiqueRecapBuilder(Object recapObject, AnalytiqueParameters analytiqueParameters, Currencies currencies, OperationDef[] operationDefArray) {
        if (recapObject == null) {
            throw new IllegalArgumentException("recapObject is null");
        }
        this.recapObject = recapObject;
        this.analytiqueParameters = analytiqueParameters;
        this.currencies = currencies;
        int currencyLength = currencies.size();
        this.ligneChronologyBuilder = new MoneyChronologyBuilder(currencyLength);
        this.depenseChronologyBuilder = new MoneyChronologyBuilder(currencyLength);
        this.apportChronologyBuilder = new MoneyChronologyBuilder(currencyLength);
        this.avanceChronologyBuilder = new MoneyChronologyBuilder(currencyLength);
        this.avenirChronologyBuilder = new MoneyChronologyBuilder(currencyLength);
        int operationDefLength = operationDefArray.length;
        this.operationBuilderArray = new OperationBuilder[operationDefLength];
        for (int i = 0; i < operationDefLength; ++i) {
            OperationDef operationDef = operationDefArray[i];
            OperationBuilder operationBuilder = operationDef instanceof AgregatDef ? new AgregatBuilder((AgregatDef)operationDef, currencyLength) : new OperationBuilder(operationDef, currencyLength);
            this.operationBuilderArray[i] = operationBuilder;
            this.operationBuilderMap.put(operationDef.getName(), operationBuilder);
            if (!(operationDef instanceof CustomLigneDef)) continue;
            String name = operationDef.getName();
            if (name.equals("_apport_")) {
                this.apportIndex = i;
                continue;
            }
            if (name.equals("_depense_")) {
                this.depenseIndex = i;
                continue;
            }
            if (name.equals("_avance_")) {
                this.avanceIndex = i;
                continue;
            }
            if (!name.equals("_avenir_depense_")) continue;
            this.avenirDepenseIndex = i;
        }
    }

    public AgregatBuilder getAgregatBuilder(int operationIndex) {
        return (AgregatBuilder)this.operationBuilderArray[operationIndex];
    }

    public void addApport(int currencyIndex, long moneyLong, FuzzyDate fuzzyDate) {
        this.operationBuilderArray[this.apportIndex].add(currencyIndex, moneyLong);
        this.ligneChronologyBuilder.add(currencyIndex, moneyLong, fuzzyDate);
        this.apportChronologyBuilder.add(currencyIndex, moneyLong, fuzzyDate);
    }

    public void addDepense(int currencyIndex, long moneyLong, FuzzyDate fuzzyDate) {
        this.operationBuilderArray[this.depenseIndex].add(currencyIndex, moneyLong);
        this.ligneChronologyBuilder.add(currencyIndex, -moneyLong, fuzzyDate);
        this.depenseChronologyBuilder.add(currencyIndex, moneyLong, fuzzyDate);
    }

    public void addAvanceNonSoldee(int currencyIndex, long moneyLong, FuzzyDate fuzzyDate) {
        this.operationBuilderArray[this.avanceIndex].add(currencyIndex, moneyLong);
        this.ligneChronologyBuilder.add(currencyIndex, -moneyLong, fuzzyDate);
        this.avanceChronologyBuilder.add(currencyIndex, moneyLong, fuzzyDate);
    }

    public void addDepenseAvenir(int currencyIndex, long moneyLong, FuzzyDate fuzzyDate) {
        this.operationBuilderArray[this.avenirDepenseIndex].add(currencyIndex, moneyLong);
        this.avenirChronologyBuilder.add(currencyIndex, -moneyLong, fuzzyDate);
    }

    public void addSubRecap(AnalytiqueRecap subRecap) {
        this.childList.add(subRecap);
    }

    public AnalytiqueRecap toAnalytiqueRecap() {
        List<AnalytiqueRecap> finalSubRecapList;
        int operationLength = this.operationBuilderArray.length;
        for (int i = 0; i < operationLength; ++i) {
            OperationBuilder operationBuilder = this.operationBuilderArray[i];
            if (!operationBuilder.isSolde()) continue;
            this.computeSolde(i, operationBuilder);
        }
        int size = this.childList.size();
        if (size > 0) {
            for (AnalytiqueRecap child : this.childList) {
                for (int i = 0; i < operationLength; ++i) {
                    OperationBuilder operationbuilder = this.operationBuilderArray[i];
                    if (!operationbuilder.isRecursive()) continue;
                    operationbuilder.addOperation(child.getOperationList().get(i));
                }
                this.ligneChronologyBuilder.add(child.getLigneMoneyChronology());
                this.depenseChronologyBuilder.add(child.getDepenseMoneyChronology());
                this.apportChronologyBuilder.add(child.getApportMoneyChronology());
                this.avanceChronologyBuilder.add(child.getAvanceMoneyChronology());
                this.avenirChronologyBuilder.add(child.getAvenirMoneyChronology());
            }
            finalSubRecapList = AnalytiqueUtils.wrap(this.childList.toArray(new AnalytiqueRecap[size]));
        } else {
            finalSubRecapList = EMPTY_LIST;
        }
        Operation[] operationArray = new Operation[operationLength];
        for (int i = 0; i < operationLength; ++i) {
            operationArray[i] = this.operationBuilderArray[i].toOperation();
        }
        List<Operation> finalOperationList = AnalytiqueUtils.wrap(operationArray);
        return new InternalAnalytiqueRecap(this.recapObject, this.analytiqueParameters, this.currencies, finalOperationList, this.ligneChronologyBuilder.toMoneyChronology(), this.depenseChronologyBuilder.toMoneyChronology(), this.apportChronologyBuilder.toMoneyChronology(), this.avanceChronologyBuilder.toMoneyChronology(), this.avenirChronologyBuilder.toMoneyChronology(), finalSubRecapList);
    }

    private void computeSolde(int soldeDefIndex, OperationBuilder soldeBuilder) {
        SoldeDef soldeDef = (SoldeDef)soldeBuilder.getOperationDef();
        boolean withComplete = soldeDef.getRecursiveType() == 2 && this.childList != null;
        try {
            for (SoldeOperand soldeOperand : soldeDef.getSoldeOperandList()) {
                String name = soldeOperand.getName();
                if (name.equals("_lignes_")) {
                    soldeBuilder.addToSolde(this.ligneChronologyBuilder.getMoneyByCurrency(), soldeOperand);
                    if (!withComplete) continue;
                    for (AnalytiqueRecap child : this.childList) {
                        if (!child.getOperationList().get(soldeDefIndex).getMoneyByCurrency().isEmpty()) continue;
                        soldeBuilder.addToSolde(child.getLigneMoneyChronology().getMoneyByCurrency(), soldeOperand);
                    }
                    continue;
                }
                if (name.equals("_avenir_")) {
                    soldeBuilder.addToSolde(this.avenirChronologyBuilder.getMoneyByCurrency(), soldeOperand);
                    if (!withComplete) continue;
                    for (AnalytiqueRecap child : this.childList) {
                        if (!child.getOperationList().get(soldeDefIndex).getMoneyByCurrency().isEmpty()) continue;
                        soldeBuilder.addToSolde(child.getAvenirMoneyChronology().getMoneyByCurrency(), soldeOperand);
                    }
                    continue;
                }
                OperationBuilder otherBuilder = this.operationBuilderMap.get(name);
                if (otherBuilder == null) continue;
                soldeBuilder.addToSolde(otherBuilder, soldeOperand);
            }
        }
        catch (MandatoryException mandatoryException) {
            // empty catch block
        }
    }

    private static List<AnalytiqueRecap.Year> checkChronology(MoneyChronology ligneMoneyChronology, MoneyChronology avenirMoneyChronology) {
        YearListChecker checker = new YearListChecker(ligneMoneyChronology, avenirMoneyChronology);
        return checker.check();
    }

    private static class InternalAnalytiqueRecap
    implements AnalytiqueRecap {
        private final Object recapObject;
        private final AnalytiqueParameters analytiqueParameters;
        private final Currencies currencies;
        private final List<Operation> operationList;
        private final MoneyChronology ligneMoneyChronology;
        private final MoneyChronology depenseMoneyChronology;
        private final MoneyChronology apportMoneyChronology;
        private final MoneyChronology avanceMoneyChronology;
        private final MoneyChronology avenirMoneyChronology;
        private final List<AnalytiqueRecap> subRecapList;
        private final List<AnalytiqueRecap.Year> yearList;

        private InternalAnalytiqueRecap(Object recapObject, AnalytiqueParameters analytiqueParameters, Currencies currencies, List<Operation> operationList, MoneyChronology ligneMoneyChronology, MoneyChronology depenseMoneyChronology, MoneyChronology apportMoneyChronology, MoneyChronology avanceMoneyChronology, MoneyChronology avenirMoneyChronology, List<AnalytiqueRecap> subRecapList) {
            this.recapObject = recapObject;
            this.currencies = currencies;
            this.analytiqueParameters = analytiqueParameters;
            this.operationList = operationList;
            this.ligneMoneyChronology = ligneMoneyChronology;
            this.depenseMoneyChronology = depenseMoneyChronology;
            this.apportMoneyChronology = apportMoneyChronology;
            this.avanceMoneyChronology = avanceMoneyChronology;
            this.avenirMoneyChronology = avenirMoneyChronology;
            this.subRecapList = subRecapList;
            this.yearList = AnalytiqueRecapBuilder.checkChronology(ligneMoneyChronology, avenirMoneyChronology);
        }

        @Override
        public Object getRecapObject() {
            return this.recapObject;
        }

        @Override
        public AnalytiqueParameters getAnalytiqueParameters() {
            return this.analytiqueParameters;
        }

        @Override
        public boolean isEmpty() {
            if (!this.ligneMoneyChronology.getMoneyByCurrency().isEmpty()) {
                return false;
            }
            if (!this.avenirMoneyChronology.getMoneyByCurrency().isEmpty()) {
                return false;
            }
            for (AnalytiqueRecap recap : this.subRecapList) {
                if (recap.isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<AnalytiqueRecap> getSubRecapList() {
            return this.subRecapList;
        }

        @Override
        public Currencies getCurrencies() {
            return this.currencies;
        }

        @Override
        public List<Operation> getOperationList() {
            return this.operationList;
        }

        @Override
        public MoneyChronology getLigneMoneyChronology() {
            return this.ligneMoneyChronology;
        }

        @Override
        public MoneyChronology getDepenseMoneyChronology() {
            return this.depenseMoneyChronology;
        }

        @Override
        public MoneyChronology getApportMoneyChronology() {
            return this.apportMoneyChronology;
        }

        @Override
        public MoneyChronology getAvanceMoneyChronology() {
            return this.avanceMoneyChronology;
        }

        @Override
        public MoneyChronology getAvenirMoneyChronology() {
            return this.avenirMoneyChronology;
        }

        @Override
        public List<AnalytiqueRecap.Year> getYearList() {
            return this.yearList;
        }
    }

    private static class YearListChecker {
        private final MoneyChronology ligneMoneyChronology;
        private final MoneyChronology avenirMoneyChronology;
        private final SortedMap<Integer, InternalYear> yearMap = new TreeMap<Integer, InternalYear>();

        private YearListChecker(MoneyChronology ligneMoneyChronology, MoneyChronology avenirMoneyChronology) {
            this.ligneMoneyChronology = ligneMoneyChronology;
            this.avenirMoneyChronology = avenirMoneyChronology;
        }

        private List<AnalytiqueRecap.Year> check() {
            this.check(this.ligneMoneyChronology);
            this.check(this.avenirMoneyChronology);
            AnalytiqueRecap.Year[] finalArray = new AnalytiqueRecap.Year[this.yearMap.size()];
            this.yearMap.values().toArray(finalArray);
            return new YearList(finalArray);
        }

        private void check(MoneyChronology moneyChronology) {
            for (MoneyChronology.Year year : moneyChronology.getYearList()) {
                int yearValue = year.getYear();
                if (this.yearMap.containsKey(yearValue)) continue;
                this.yearMap.put(yearValue, new InternalYear(yearValue));
            }
        }
    }

    private static class YearList
    extends AbstractList<AnalytiqueRecap.Year>
    implements RandomAccess {
        private final AnalytiqueRecap.Year[] array;

        private YearList(AnalytiqueRecap.Year[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AnalytiqueRecap.Year get(int index) {
            return this.array[index];
        }
    }

    private static class InternalYear
    implements AnalytiqueRecap.Year {
        private final int year;

        private InternalYear(int year) {
            this.year = year;
        }

        @Override
        public int getYear() {
            return this.year;
        }
    }
}

