/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeOperand;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.LigneHolder;
import fr.exemole.bdfext.scarabe.api.core.LigneKey;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueGatheringBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.LigneListsBuffer;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AgregatGatheringBuilder;
import java.util.Collection;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.include.IncludeMode;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.money.Currencies;

public class PopulateEngine {
    protected final AliasHolder coreAliasHolder;
    protected final LigneHolder ligneHolder;
    protected final Currencies currencies;

    public PopulateEngine(AliasHolder coreAliasHolder, LigneHolder ligneHolder, Currencies currencies) {
        this.coreAliasHolder = coreAliasHolder;
        this.ligneHolder = ligneHolder;
        this.currencies = currencies;
    }

    public void populateLignes(SubsetItemPointeur analytiqueItemPointeur, LigneListsBuffer ligneListsBuffer) {
        Ligne ligne;
        LigneKey ligneKey;
        FicheMeta ficheMeta;
        for (Liaison liaison : analytiqueItemPointeur.getStandardLiaisons((Subset)this.coreAliasHolder.getCorpus("depense"))) {
            ficheMeta = (FicheMeta)liaison.getSubsetItem();
            ligneKey = LigneKey.get("depense", ficheMeta.getId());
            ligne = this.ligneHolder.getLigne(ligneKey);
            if (ligne != null) {
                ligneListsBuffer.addDepenseLigne(ligne);
                continue;
            }
            Avenir avenir = this.ligneHolder.getAvenir(ligneKey);
            if (avenir == null) continue;
            ligneListsBuffer.addDepenseAvenir(avenir);
        }
        for (Liaison liaison : analytiqueItemPointeur.getStandardLiaisons((Subset)this.coreAliasHolder.getCorpus("apport"))) {
            ficheMeta = (FicheMeta)liaison.getSubsetItem();
            ligneKey = LigneKey.get("apport", ficheMeta.getId());
            ligne = this.ligneHolder.getLigne(ligneKey);
            if (ligne == null) continue;
            ligneListsBuffer.addApportLigne(ligne);
        }
        for (Liaison liaison : analytiqueItemPointeur.getStandardLiaisons((Subset)this.coreAliasHolder.getCorpus("avance"))) {
            LigneKey soldeAvanceLigneKey;
            Ligne soldeAvanceLigne;
            ficheMeta = (FicheMeta)liaison.getSubsetItem();
            LigneKey avanceLigneKey = LigneKey.get("avance", ficheMeta.getId(), false);
            Ligne avanceLigne = this.ligneHolder.getLigne(avanceLigneKey);
            if (avanceLigne != null) {
                ligneListsBuffer.addAvanceLigne(avanceLigne);
            }
            if ((soldeAvanceLigne = this.ligneHolder.getLigne(soldeAvanceLigneKey = LigneKey.get("avance", ficheMeta.getId(), true))) == null) continue;
            ligneListsBuffer.addSoldeAvanceLigne(soldeAvanceLigne);
        }
    }

    public void populateAgregat(AnalytiqueDef analytiqueDef, SubsetItemPointeur pointeur, AnalytiqueGatheringBuilder analytiqueGatheringBuilder, Currencies currencies) {
        List<OperationDef> operationDefList = analytiqueDef.getOperationDefList();
        int operationDefLength = operationDefList.size();
        for (int i = 0; i < operationDefLength; ++i) {
            AgregatDef agregatDef;
            OperationDef operationDef = operationDefList.get(i);
            if (!(operationDef instanceof AgregatDef) || !analytiqueGatheringBuilder.accept(agregatDef = (AgregatDef)operationDef)) continue;
            AgregatGatheringBuilder builder = analytiqueGatheringBuilder.getAgregatGatheringBuilder(i, currencies.size());
            this.populate(builder, pointeur, agregatDef, analytiqueGatheringBuilder.getMessageHandler(), currencies);
        }
    }

    public void populate(AgregatGatheringBuilder builder, SubsetItemPointeur matchingGatheringPointeur, AgregatDef agregatDef, MessageHandler messageHandler, Currencies currencies) {
        if (matchingGatheringPointeur instanceof FichePointeur) {
            MutableMoneyByCurrency moneyByCurrency = PopulateEngine.populateCorpusField((FichePointeur)matchingGatheringPointeur, agregatDef.getCorpusFieldList(), messageHandler, currencies);
            builder.add(matchingGatheringPointeur.getCurrentSubsetItem(), moneyByCurrency);
        }
        for (AgregatDef.ParentageDef parentageDef : agregatDef.getParentageDefList()) {
            FichePointeur parentagePointeur = (FichePointeur)matchingGatheringPointeur.getParentagePointeur(parentageDef.getCorpus().getSubsetKey());
            MutableMoneyByCurrency moneyByCurrency = PopulateEngine.populateCorpusField(parentagePointeur, parentageDef.getCorpusFieldList(), messageHandler, currencies);
            builder.add(parentagePointeur.getCurrentSubsetItem(), moneyByCurrency);
        }
        for (AgregatDef.CroisementDef croisementDef : agregatDef.getCroisementDefList()) {
            boolean withVariation;
            Corpus croisementCorpus = croisementDef.getCorpus();
            Croisements ficheCroisements = matchingGatheringPointeur.getCroisements((Subset)croisementCorpus);
            List<SoldeOperand> variationOperandList = croisementDef.getVariationOperandList();
            boolean bl = withVariation = !variationOperandList.isEmpty();
            if (ficheCroisements.isEmpty()) continue;
            IncludeKey includeKey = croisementDef.getIncludeKey();
            Collection liaisons = CroisementUtils.filter((Croisements)ficheCroisements, (IncludeMode)includeKey);
            List<CorpusField> corpusFieldList = croisementDef.getCorpusFieldList();
            FichePointeur otherPointeur = PointeurFactory.newFichePointeur((Corpus)croisementCorpus);
            for (Liaison liaison : liaisons) {
                otherPointeur.setCurrentSubsetItem(liaison.getSubsetItem());
                MutableMoneyByCurrency moneyByCurrency = PopulateEngine.populateCorpusField(otherPointeur, corpusFieldList, messageHandler, currencies);
                if (withVariation) {
                    LigneListsBuffer ligneListsBuffer = new LigneListsBuffer();
                    this.populateLignes((SubsetItemPointeur)otherPointeur, ligneListsBuffer);
                    for (Ligne ligne : ligneListsBuffer.depenseList) {
                        moneyByCurrency.add(ligne.getMouvement().getCurrencyIndex(), ligne.getComputeMoneyLong());
                    }
                }
                builder.add(otherPointeur.getCurrentSubsetItem(), moneyByCurrency);
            }
        }
    }

    private static MutableMoneyByCurrency populateCorpusField(FichePointeur fichePointeur, List<CorpusField> corpusFieldList, MessageHandler messageHandler, Currencies currencies) {
        MutableMoneyByCurrency moneyByCurrency = new MutableMoneyByCurrency(currencies.size());
        for (CorpusField corpusField : corpusFieldList) {
            FieldKey fieldKey = corpusField.getFieldKey();
            Object obj = fichePointeur.getValue(fieldKey);
            if (obj == null) continue;
            if (obj instanceof FicheItem) {
                if (obj instanceof AmountItem) {
                    AmountItem montant = (AmountItem)obj;
                    int currencyIndex = currencies.indexOf((Object)montant.getCurrency());
                    if (currencyIndex == -1) {
                        AnalytiqueUtils.addWarning(messageHandler, "_ error.unknown.scarabe.currency_agregat", fieldKey, fichePointeur.getSubsetKey());
                        continue;
                    }
                    moneyByCurrency.add(currencyIndex, montant.toMoneyLong());
                    continue;
                }
                AnalytiqueUtils.addWarning(messageHandler, "_ error.wrong.scarabe.notmontant_agregat", fieldKey, fichePointeur.getSubsetKey());
                continue;
            }
            if (!(obj instanceof FicheItems)) continue;
            FicheItems fil = (FicheItems)obj;
            int size = fil.size();
            for (int j = 0; j < size; ++j) {
                FicheItem ficheItem = (FicheItem)fil.get(j);
                if (ficheItem instanceof AmountItem) {
                    AmountItem montant = (AmountItem)ficheItem;
                    int currencyIndex = currencies.indexOf((Object)montant.getCurrency());
                    if (currencyIndex == -1) {
                        AnalytiqueUtils.addWarning(messageHandler, "_ error.unknown.scarabe.currency_agregat", fieldKey, fichePointeur.getSubsetKey());
                        continue;
                    }
                    moneyByCurrency.add(currencyIndex, montant.toMoneyLong());
                    continue;
                }
                AnalytiqueUtils.addWarning(messageHandler, "_ error.wrong.scarabe.notmontant_agregat", fieldKey, fichePointeur.getSubsetKey());
            }
        }
        return moneyByCurrency;
    }
}

